/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.jinput;

import java.util.HashMap;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.MouseFactory;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.render.InputSourceWindow;

public class JInputMouse
extends Mouse {
    private static final HashMap<Component, DeviceComponent> compMap = new HashMap();
    private final net.java.games.input.Mouse mouse;
    private Event event = new Event();

    public static final MouseButton convertButton(Component jinputButton) {
        DeviceComponent comp = compMap.get(jinputButton);
        if (comp == null || !(comp instanceof MouseButton)) {
            return null;
        }
        return (MouseButton)comp;
    }

    public void setPosition(int x, int y) throws InputSystemException {
        super.setPosition(x, y);
        try {
            if (!this.isAbsolute()) {
                this.storePosition(x, y);
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void centerMouse() throws InputSystemException {
        int centerX = 0;
        int centerY = 0;
        try {
            centerX = this.getSourceWindow().getWidth() / 2;
            centerY = this.getSourceWindow().getHeight() / 2;
        }
        catch (Throwable t) {
            throw new InputSystemException(t);
        }
        this.setPosition(centerX, centerY);
    }

    private final void collectOrFireEvents(InputSystem is, EventQueue eventQueue, long nanoTime, boolean acceptsEvents) throws InputSystemException {
        boolean isQueued = eventQueue != null;
        try {
            this.getEventQueue().dequeueAndFire(is, InputEvent.Type.MOUSE_EVENT);
            this.mouse.poll();
            int dx = 0;
            int dy = 0;
            block11: while (this.mouse.getEventQueue().getNextEvent(this.event)) {
                if (!acceptsEvents) continue;
                DeviceComponent comp = compMap.get(this.event.getComponent());
                switch (comp.getType()) {
                    case MOUSE_AXIS: {
                        MouseAxis axis = (MouseAxis)comp;
                        switch (axis.getID()) {
                            case 'X': {
                                int dx_ = (int)this.event.getComponent().getPollData();
                                dx += dx_;
                                if (!this.isAbsolute()) break;
                                this.storePosition(this.getCurrentX() + dx_, this.getCurrentY());
                                break;
                            }
                            case 'Y': {
                                int dy_ = (int)this.event.getComponent().getPollData();
                                dy += dy_;
                                if (!this.isAbsolute()) break;
                                this.storePosition(this.getCurrentX(), this.getCurrentY() + dy_);
                            }
                        }
                        continue block11;
                    }
                    case MOUSE_BUTTON: {
                        MouseButton button = (MouseButton)comp;
                        if (!this.isButtonPressed(button)) {
                            MouseButtonPressedEvent pressedEv = this.prepareMouseButtonPressedEvent(button, nanoTime);
                            is.notifyInputStatesManagers(this, button, 1, 1, nanoTime);
                            if (pressedEv == null) continue block11;
                            if (isQueued) {
                                eventQueue.enqueue(pressedEv);
                                break;
                            }
                            this.fireOnMouseButtonPressed(pressedEv, true);
                            break;
                        }
                        MouseButtonReleasedEvent releasedEv = this.prepareMouseButtonReleasedEvent(button, nanoTime);
                        is.notifyInputStatesManagers(this, button, 0, -1, nanoTime);
                        if (releasedEv == null) continue block11;
                        if (isQueued) {
                            eventQueue.enqueue(releasedEv);
                            break;
                        }
                        this.fireOnMouseButtonReleased(releasedEv, true);
                        break;
                    }
                    case MOUSE_WHEEL: {
                        int wheelDelta = (int)this.event.getValue();
                        MouseWheelEvent wheelEv = this.prepareMouseWheelMovedEvent(wheelDelta, false, nanoTime);
                        is.notifyInputStatesManagers(this, this.getWheel(), this.getWheel().getIntValue(), wheelDelta, nanoTime);
                        if (wheelEv == null) continue block11;
                        if (isQueued) {
                            eventQueue.enqueue(wheelEv);
                            break;
                        }
                        this.fireOnMouseWheelMoved(wheelEv, true);
                    }
                }
            }
            if (dx != 0 || dy != 0) {
                MouseMovedEvent movedEv = this.prepareMouseMovedEvent(this.getCurrentX(), this.getCurrentY(), dx, dy, nanoTime);
                if (dx != 0) {
                    is.notifyInputStatesManagers(this, this.getXAxis(), this.getCurrentX(), dx, nanoTime);
                }
                if (dy != 0) {
                    is.notifyInputStatesManagers(this, this.getYAxis(), this.getCurrentY(), dy, nanoTime);
                }
                if (movedEv != null) {
                    if (isQueued) {
                        eventQueue.enqueue(movedEv);
                    } else {
                        this.fireOnMouseMoved(movedEv, true);
                    }
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, false);
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        if (eventQueue == null) {
            throw new InputSystemException("EventQueue must not be null here!");
        }
        boolean acceptEvents = this.isEnabled() && this.getSourceWindow().receivesInputEvents();
        this.collectOrFireEvents(is, eventQueue, nanoTime, acceptEvents);
    }

    public void updateMouse(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, true);
        this.getEventQueue().dequeueAndFire(is, InputEvent.Type.MOUSE_EVENT);
        this.handleClickedEvents(nanoTime, is.getMouseButtonClickThreshold());
    }

    protected void setAbsoluteImpl(boolean absolute) throws InputSystemException {
    }

    public void onDeviceRegistered(InputSystem inputSystem) throws InputSystemException {
        this.consumePendingEvents(inputSystem, null, -1L);
    }

    public void destroyImpl() throws InputSystemException {
    }

    private static int init_getNumButtons(net.java.games.input.Mouse mouse) throws InputSystemException {
        Component[] comps = mouse.getComponents();
        int extIndex = 3;
        int oldCount = compMap.size();
        int i = 0;
        while (i < comps.length) {
            if (comps[i].getIdentifier().getClass().getSimpleName().equals("Button")) {
                if (comps[i].getName().equals("Left")) {
                    compMap.put(comps[i], MouseButtons.LEFT_BUTTON);
                } else if (comps[i].getName().equals("Right")) {
                    compMap.put(comps[i], MouseButtons.RIGHT_BUTTON);
                } else if (comps[i].getName().equals("Middle")) {
                    compMap.put(comps[i], MouseButtons.MIDDLE_BUTTON);
                } else {
                    compMap.put(comps[i], MouseButtons.getByIndex(extIndex++));
                }
            }
            ++i;
        }
        return compMap.size() - oldCount;
    }

    private static boolean init_hasWheel(net.java.games.input.Mouse mouse) throws InputSystemException {
        Component[] comps = mouse.getComponents();
        boolean hasWheel = false;
        int i = 0;
        while (i < comps.length) {
            if (comps[i].getName().equals("z")) {
                hasWheel = true;
            }
            ++i;
        }
        return hasWheel;
    }

    protected JInputMouse(MouseFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue, net.java.games.input.Mouse mouse) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, mouse.getName(), JInputMouse.init_getNumButtons(mouse), JInputMouse.init_hasWheel(mouse));
        this.mouse = mouse;
        if (this.getWheel() != null) {
            Component[] comps = mouse.getComponents();
            int i = 0;
            while (i < comps.length) {
                if (comps[i].getName().equals("x")) {
                    compMap.put(comps[i], this.getXAxis());
                } else if (comps[i].getName().equals("y")) {
                    compMap.put(comps[i], this.getYAxis());
                } else if (comps[i].getName().equals("z")) {
                    compMap.put(comps[i], this.getWheel());
                }
                ++i;
            }
        }
    }
}

