/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.lwjgl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.jagatoo.util.nio.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;

public class LWJGLCursorConverter {
    public static void convertCursor(org.jagatoo.input.render.Cursor cursor) {
        if (cursor.getCursorObject() != null && cursor.getCursorObject() instanceof Cursor) {
            return;
        }
        int width = cursor.getWidth();
        int height = cursor.getHeight();
        int hotSpotX = cursor.getHotSpotX();
        int hotSpotY = cursor.getHotSpotY();
        int numImages = cursor.getImagesCount();
        IntBuffer imagesBuffer = ByteBuffer.allocateDirect(width * height * numImages * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        imagesBuffer.position(0);
        int i = 0;
        while (i < numImages) {
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int color = cursor.getImage(i).getRGB(width - x - 1, y);
                    imagesBuffer.put(color);
                    ++y;
                }
                ++x;
            }
            ++i;
        }
        imagesBuffer.rewind();
        IntBuffer delaysBuffer = BufferUtils.createIntBuffer(numImages);
        int i2 = 0;
        while (i2 < numImages) {
            delaysBuffer.put(i2, cursor.getDelay(i2));
            ++i2;
        }
        try {
            cursor.setCursorObject(new Cursor(width, height, hotSpotX, height - hotSpotY - 1, numImages, imagesBuffer, delaysBuffer));
        }
        catch (LWJGLException e) {
            throw new Error(e);
        }
    }
}

