/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.localization.mappings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import org.jagatoo.input.InputSystem;
import org.jagatoo.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyLocalizationParser {
    private static final StringBuffer stringBuffer = new StringBuffer();

    private static String parseLine(String line, Map<String, String> map) {
        int phase = 0;
        boolean isInQuotes = false;
        String key = null;
        String value = null;
        stringBuffer.setLength(0);
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            switch (phase) {
                case 0: {
                    if (ch == '\"') {
                        isInQuotes = true;
                    } else {
                        stringBuffer.setLength(0);
                        stringBuffer.append(ch);
                    }
                    ++phase;
                    break;
                }
                case 1: {
                    if (isInQuotes) {
                        if (ch != '\"') {
                            stringBuffer.append(ch);
                            break;
                        }
                        if (stringBuffer.length() > 0) {
                            key = stringBuffer.toString();
                            ++phase;
                        } else {
                            return null;
                        }
                        isInQuotes = false;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (stringBuffer.length() <= 0) break;
                        key = stringBuffer.toString();
                        ++phase;
                        break;
                    }
                    if (ch == '=') {
                        if (stringBuffer.length() > 0) {
                            key = stringBuffer.toString();
                            phase += 2;
                            break;
                        }
                        return null;
                    }
                    if (ch == '\"') {
                        return null;
                    }
                    stringBuffer.append(ch);
                    break;
                }
                case 2: {
                    if (Character.isWhitespace(ch)) break;
                    if (ch == '=') {
                        ++phase;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (key == null) {
                        return null;
                    }
                    if (Character.isWhitespace(ch)) break;
                    stringBuffer.setLength(0);
                    if (ch == '\"') {
                        isInQuotes = true;
                    } else {
                        stringBuffer.append(ch);
                    }
                    ++phase;
                    break;
                }
                case 4: {
                    if (isInQuotes) {
                        if (ch == '\"') {
                            isInQuotes = false;
                            if (stringBuffer.length() > 0) {
                                value = stringBuffer.toString();
                                map.put(key, value);
                                return key;
                            }
                            return null;
                        }
                        stringBuffer.append(ch);
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (stringBuffer.length() > 0) {
                            value = stringBuffer.toString();
                            map.put(key, value);
                            return key;
                        }
                        return null;
                    }
                    if (ch == '\"') {
                        return null;
                    }
                    stringBuffer.append(ch);
                }
            }
            ++i;
        }
        if (key == null || phase < 4) {
            return null;
        }
        if (value == null && stringBuffer.length() > 0) {
            value = stringBuffer.toString();
        }
        if (value != null) {
            map.put(key, value);
            return key;
        }
        return null;
    }

    public static int parse(InputStream in, Map<String, String> map) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        int numValidLines = 0;
        int lineNum = 0;
        String line = null;
        while ((line = br.readLine()) != null) {
            line = line.trim();
            ++lineNum;
            if (line.length() == 0 || line.startsWith("#")) continue;
            String key = KeyLocalizationParser.parseLine(line, map);
            if (key != null) {
                Log.debug(InputSystem.LOG_CHANNEL, "Parsed valid line #", lineNum);
                ++numValidLines;
                continue;
            }
            Log.debug(InputSystem.LOG_CHANNEL, "Invalid line #", lineNum);
        }
        return numValidLines;
    }

    public static int parse(URL resource, Map<String, String> map) throws IOException {
        return KeyLocalizationParser.parse(resource.openStream(), map);
    }
}

