/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.managers;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.InvokableInputAction;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.MouseWheel;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.listeners.InputStateListener;
import org.jagatoo.input.managers.InputBindingsManager;
import org.jagatoo.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputBindingsAdapter<A extends InvokableInputAction>
extends InputBindingsManager<A>
implements InputStateListener {
    private final InvokableInputAction checkMouseWheel(DeviceComponent comp, int delta) {
        MouseWheel wheel = (MouseWheel)comp;
        InvokableInputAction action = (InvokableInputAction)this.getBoundAction(MouseWheel.GLOBAL_WHEEL);
        if (action == null) {
            if (delta > 0) {
                action = (InvokableInputAction)this.getBoundAction(MouseWheel.GLOBAL_WHEEL.getUp());
                if (action == null) {
                    action = (InvokableInputAction)this.getBoundAction(wheel.getUp());
                }
            } else {
                action = (InvokableInputAction)this.getBoundAction(MouseWheel.GLOBAL_WHEEL.getDown());
                if (action == null) {
                    action = (InvokableInputAction)this.getBoundAction(wheel.getDown());
                }
            }
        }
        return action;
    }

    @Override
    public void onInputStateChanged(InputEvent e, DeviceComponent comp, int delta, int state) {
        InvokableInputAction action = (InvokableInputAction)this.getBoundAction(comp);
        if (action == null && comp != null && comp.getType() == DeviceComponent.Type.MOUSE_WHEEL) {
            action = this.checkMouseWheel(comp, delta);
        }
        if (action != null) {
            try {
                action.invokeAction(null, comp, delta, state, e.getWhen());
            }
            catch (InputSystemException ex) {
                Log.print(InputSystem.LOG_CHANNEL, ex);
                ex.printStackTrace();
            }
        }
    }

    public InputBindingsAdapter(int numCommands) {
        super(numCommands);
    }
}

