/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jagatoo.input.actions.InputAction;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.managers.InputBindingListener;
import org.jagatoo.input.managers.InputBindingsSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputBindingsManager<A extends InputAction> {
    protected static final int NUM_KEY_SETS = InputBindingsSet.values().length;
    private final HashMap<DeviceComponent, A> keyBindings;
    protected final DeviceComponent[][] boundKeys;
    private final ArrayList<InputBindingListener<A>> listeners = new ArrayList();

    public final void addInputBindingListener(InputBindingListener<A> l) {
        this.listeners.add(l);
    }

    public final void removeInputBindingListener(InputBindingListener<A> l) {
        this.listeners.remove(l);
    }

    protected final void notifyBound(DeviceComponent key, InputBindingsSet set, A action) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onInputComponentBound(key, set, action);
            ++i;
        }
    }

    protected final void notifyUnbound(DeviceComponent key, InputBindingsSet set, A action) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onInputComponentUnbound(key, set, action);
            ++i;
        }
    }

    public final int getNumActions() {
        return this.boundKeys.length;
    }

    public final Set<DeviceComponent> getBoundInputComponents() {
        return this.keyBindings.keySet();
    }

    public final int getBoundInputComponents(DeviceComponent[] result) {
        if (result.length < this.keyBindings.size()) {
            throw new ArrayIndexOutOfBoundsException("result array smaller than " + this.keyBindings.size());
        }
        int i = 0;
        for (DeviceComponent comp : this.keyBindings.keySet()) {
            result[i++] = comp;
        }
        return i;
    }

    public final Collection<A> getBoundActions() {
        return this.keyBindings.values();
    }

    public final void getBoundActions(DeviceComponent[] components, InputAction[] result) {
        int i = 0;
        while (i < components.length) {
            A action = this.getBoundAction(components[i]);
            result[i] = action;
            ++i;
        }
    }

    public final A unbind(DeviceComponent comp) {
        int ordinal;
        InputAction prevBound = (InputAction)this.keyBindings.remove(comp);
        if (prevBound != null && this.boundKeys[ordinal = prevBound.ordinal()] != null) {
            int i = 0;
            while (i < NUM_KEY_SETS) {
                if (this.boundKeys[ordinal][i] == comp) {
                    this.boundKeys[ordinal][i] = null;
                    this.notifyUnbound(comp, InputBindingsSet.values()[i], prevBound);
                    return (A)prevBound;
                }
                ++i;
            }
        }
        return null;
    }

    public final DeviceComponent unbind(A action) {
        DeviceComponent[] bounds = this.boundKeys[action.ordinal()];
        if (bounds == null) {
            return null;
        }
        DeviceComponent prev = null;
        DeviceComponent[] prevs = new DeviceComponent[NUM_KEY_SETS];
        int i = 0;
        while (i < NUM_KEY_SETS) {
            if (prev == null && bounds[i] != null) {
                prev = bounds[i];
            }
            prevs[i] = bounds[i];
            ++i;
        }
        i = 0;
        while (i < prevs.length) {
            if (prevs[i] != null) {
                this.unbind(prevs[i]);
            }
            ++i;
        }
        return prev;
    }

    public final A getBoundAction(DeviceComponent comp, InputBindingsSet set) {
        if (set == null) {
            return (A)((InputAction)this.keyBindings.get(comp));
        }
        InputAction result = (InputAction)this.keyBindings.get(comp);
        if (this.boundKeys[result.ordinal()] != null && this.boundKeys[result.ordinal()][set.ordinal()] == comp) {
            return (A)result;
        }
        return null;
    }

    public final A getBoundAction(DeviceComponent comp) {
        return this.getBoundAction(comp, null);
    }

    public final DeviceComponent getBoundComponent(A action, InputBindingsSet set) {
        DeviceComponent[] keys = this.boundKeys[action.ordinal()];
        if (keys == null) {
            return null;
        }
        return keys[set.ordinal()];
    }

    public final InputBindingsSet bind(DeviceComponent comp, A action, InputBindingsSet set) {
        DeviceComponent[] keys = this.boundKeys[action.ordinal()];
        if (keys == null) {
            keys = new DeviceComponent[NUM_KEY_SETS];
            this.boundKeys[action.ordinal()] = keys;
            int i = 0;
            while (i < NUM_KEY_SETS) {
                keys[i] = null;
                ++i;
            }
        }
        if (set == null) {
            int j = 0;
            while (j < NUM_KEY_SETS) {
                if (keys[j] == null) {
                    set = InputBindingsSet.values()[j];
                    break;
                }
                ++j;
            }
            if (set == null) {
                set = InputBindingsSet.PRIMARY;
            }
        }
        if (keys[set.ordinal()] != null) {
            this.unbind(comp);
        }
        keys[set.ordinal()] = comp;
        this.keyBindings.put(comp, action);
        this.notifyBound(comp, set, action);
        return set;
    }

    public final InputBindingsSet bind(DeviceComponent comp, A action) {
        return this.bind(comp, action, null);
    }

    public final void unbindAll(InputBindingsSet set) {
        int i = 0;
        while (i < this.boundKeys.length) {
            if (this.boundKeys[i] != null) {
                int j;
                if (set == null) {
                    j = 0;
                    while (j < NUM_KEY_SETS) {
                        if (this.boundKeys[i][j] != null) {
                            this.notifyUnbound(this.boundKeys[i][j], InputBindingsSet.values()[j], (InputAction)this.keyBindings.get(this.boundKeys[i][j]));
                            this.keyBindings.remove(this.boundKeys[i][j]);
                            this.boundKeys[i][j] = null;
                        }
                        ++j;
                    }
                } else {
                    j = set.ordinal();
                    if (this.boundKeys[i][j] != null) {
                        this.notifyUnbound(this.boundKeys[i][j], InputBindingsSet.values()[j], (InputAction)this.keyBindings.get(this.boundKeys[i][j]));
                        this.keyBindings.remove(this.boundKeys[i][j]);
                        this.boundKeys[i][j] = null;
                    }
                }
            }
            ++i;
        }
    }

    public final void unbindAll() {
        this.unbindAll(null);
    }

    public final void setInputBindings(Map<DeviceComponent, ? extends A> inputBindings, boolean clearBefore) {
        if (clearBefore) {
            this.unbindAll();
        }
        for (DeviceComponent key : inputBindings.keySet()) {
            this.bind(key, (InputAction)inputBindings.get(key));
        }
    }

    public final void setInputBindings(Map<DeviceComponent, ? extends A> inputBindings) {
        this.setInputBindings(inputBindings, true);
    }

    public Map<DeviceComponent, A> getInputBindingsMap() {
        return this.keyBindings;
    }

    public final void set(InputBindingsManager<? extends A> bindings, boolean clearBefore) {
        if (clearBefore) {
            this.unbindAll();
        }
        int n = Math.min(this.boundKeys.length, bindings.boundKeys.length);
        int i = 0;
        while (i < n) {
            int j;
            if (bindings.boundKeys[i] == null) {
                if (this.boundKeys[i] != null) {
                    j = 0;
                    while (j < NUM_KEY_SETS) {
                        this.boundKeys[i][j] = null;
                        ++j;
                    }
                }
            } else {
                if (this.boundKeys[i] == null) {
                    this.boundKeys[i] = new DeviceComponent[NUM_KEY_SETS];
                }
                j = 0;
                while (j < NUM_KEY_SETS) {
                    this.boundKeys[i][j] = bindings.boundKeys[i][j];
                    if (bindings.boundKeys[i][j] != null) {
                        this.notifyBound(bindings.boundKeys[i][j], InputBindingsSet.values()[j], (InputAction)bindings.keyBindings.get(bindings.boundKeys[i][j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (DeviceComponent comp : bindings.keyBindings.keySet()) {
            this.keyBindings.put(comp, (InputAction)bindings.keyBindings.get(comp));
        }
    }

    public final void set(InputBindingsManager<? extends A> bindings) {
        this.set(bindings, true);
    }

    public InputBindingsManager(int numCommands) {
        this.keyBindings = new HashMap();
        this.boundKeys = new DeviceComponent[numCommands][];
    }
}

