/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.util;

import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.events.ControllerAxisChangedEvent;
import org.jagatoo.input.events.ControllerButtonEvent;
import org.jagatoo.input.events.ControllerButtonPressedEvent;
import org.jagatoo.input.events.ControllerButtonReleasedEvent;
import org.jagatoo.input.listeners.ControllerListener;

public class ControllerCalibrator {
    private static Controller controller = null;
    private static Worker worker = new Worker();

    public static void start(Controller controller) {
        if (ControllerCalibrator.controller != null) {
            ControllerCalibrator.controller.removeControllerListener(worker);
        }
        ControllerCalibrator.controller = controller;
        controller.addControllerListener(worker);
    }

    public static void stop() {
        if (controller == null) {
            return;
        }
        controller.removeControllerListener(worker);
        controller = null;
    }

    private static class Worker
    implements ControllerListener {
        private Worker() {
        }

        public void onControllerAxisChanged(ControllerAxisChangedEvent e, ControllerAxis axis, float axisDelta) {
            if (axis.getFloatValue() < axis.getMinValue()) {
                axis.setMinValue(axis.getFloatValue());
            } else if (axis.getFloatValue() > axis.getMaxValue()) {
                axis.setMaxValue(axis.getFloatValue());
            }
        }

        public void onControllerButtonPressed(ControllerButtonPressedEvent e, ControllerButton button) {
        }

        public void onControllerButtonReleased(ControllerButtonReleasedEvent e, ControllerButton button) {
        }

        public void onControllerButtonStateChanged(ControllerButtonEvent e, ControllerButton button, boolean state) {
        }
    }
}

