/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models._util;

import java.io.File;
import java.io.IOException;
import java.net.URL;

public class LoaderUtils {
    public static final URL extractBaseURL(URL url) throws IOException {
        String file = url.getFile();
        String proto = url.toExternalForm().substring(0, url.toExternalForm().length() - file.length());
        int lastSlashPos = file.lastIndexOf(47);
        if (lastSlashPos < 0) {
            return null;
        }
        if (lastSlashPos == file.length() - 1) {
            throw new IllegalArgumentException("You cannot pass a directory as the url parameter!");
        }
        return new URL(String.valueOf(proto) + file.substring(0, lastSlashPos + 1));
    }

    public static final URL extractBaseURL(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("You cannot pass a directory as the file parameter!");
        }
        return file.getAbsoluteFile().getParentFile().toURI().toURL();
    }

    public static final URL extractBaseURL(String filename) throws IOException {
        return LoaderUtils.extractBaseURL(new File(filename));
    }

    public static final String extractFilenameWithoutExt(URL url, String ext) {
        String filename = url.getFile();
        int lastSlashPos = filename.lastIndexOf(47);
        if (lastSlashPos < 0) {
            return filename.substring(0, filename.length() - ext.length() - 1);
        }
        return filename.substring(lastSlashPos + 1, filename.length() - ext.length() - 1);
    }

    public static final String extractFilenameWithoutExt(URL url) {
        String filename = url.getFile();
        int lastSlashPos = filename.lastIndexOf(47);
        if (lastSlashPos < 0) {
            int lastDotPos = filename.lastIndexOf(46);
            if (lastDotPos < 0) {
                return filename;
            }
            return filename.substring(0, lastDotPos);
        }
        int lastDotPos = filename.lastIndexOf(46);
        if (lastDotPos < 0) {
            return filename.substring(lastSlashPos + 1, filename.length());
        }
        return filename.substring(lastSlashPos + 1, lastDotPos);
    }
}

