/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ase;

import java.util.ArrayList;
import java.util.List;
import org.jagatoo.loaders.models.ase.AseFileLine;
import org.jagatoo.loaders.models.ase.AseMap;
import org.jagatoo.loaders.models.ase.AseNode;
import org.jagatoo.loaders.models.ase.AseReader;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Colorf;

public class AseMaterial
extends AseNode {
    public String className;
    public String name;
    public Colorf ambient = new Colorf();
    public Colorf diffuse = new Colorf();
    public Colorf specular = new Colorf();
    public float shine;
    public float shineStrength;
    public float transparency;
    public float wireSize;
    public String shading;
    public float xpFalloff;
    public float selfIllum;
    public String fallOff;
    public String xpType;
    public AseMap opacityMap = null;
    public AseMap diffuseMap = null;
    public List<AseMaterial> subMaterials = new ArrayList<AseMaterial>();

    public AseMaterial() {
        this.properties.put("*MATERIAL_NAME", "name");
        this.properties.put("*MATERIAL_CLASS", "className");
        this.properties.put("*MATERIAL_AMBIENT", "ambient");
        this.properties.put("*MATERIAL_DIFFUSE", "diffuse");
        this.properties.put("*MATERIAL_SPECULAR", "specular");
        this.properties.put("*MATERIAL_SHINE", "shine");
        this.properties.put("*MATERIAL_SHINESTRENGTH", "shineStrength");
        this.properties.put("*MATERIAL_TRANSPARENCY", "transparency");
        this.properties.put("*MATERIAL_WIRESIZE", "wireSize");
        this.properties.put("*MATERIAL_SHADING", "shading");
        this.properties.put("*MATERIAL_XP_FALLOFF", "xpFalloff");
        this.properties.put("*MATERIAL_SELFILLUM", "selfIllum");
        this.properties.put("*MATERIAL_FALLOFF", "fallOff");
        this.properties.put("*MATERIAL_XP_TYPE", "xpType");
    }

    public void parse(AseReader in) {
        AseFileLine line;
        while ((line = in.readAseLine()) != null) {
            if (!this.parseProperty(in, line)) {
                if (line.getType() == AseFileLine.Type.MAP_OPACITY) {
                    this.opacityMap = new AseMap();
                    this.opacityMap.parse(in);
                } else if (line.getType() == AseFileLine.Type.MAP_DIFFUSE) {
                    this.diffuseMap = new AseMap();
                    this.diffuseMap.parse(in);
                } else if (line.getType() == AseFileLine.Type.SUBMATERIAL) {
                    int n = Integer.parseInt(line.getParameter(0));
                    if (n != this.subMaterials.size()) {
                        throw new Error("Sub-Material index does not match material list");
                    }
                    AseMaterial m = new AseMaterial();
                    m.parse(in);
                    JAGTLog.debug("   Parsed sub-material " + m.name);
                    this.subMaterials.add(m);
                    in.blockEnd = false;
                } else if (in.blockStart) {
                    this.trashBlock(in);
                }
            }
            if (in.blockEnd) break;
        }
    }

    public String toString() {
        return String.valueOf(this.name) + " (Appearance)";
    }
}

