/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;

public class BSPEntitiesParser {
    private static final String qs(String s) {
        if (s == null) {
            return null;
        }
        return "\"" + s + "\"";
    }

    public static BSPEntity[] parseEntites(byte[] entityBytes) {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(entityBytes)));
        ArrayList<BSPEntity_worldspawn> entities = new ArrayList<BSPEntity_worldspawn>();
        try {
            while (br.ready()) {
                String line;
                while (br.ready() && (char)br.read() != '{') {
                }
                br.mark(4096);
                boolean blockValid = true;
                String classname = null;
                do {
                    if ((line = br.readLine()) == null) {
                        blockValid = false;
                        break;
                    }
                    if (!line.startsWith("\"classname\"") || (classname = BSPEntity.parseLineValue(line)) != null) continue;
                    blockValid = false;
                    break;
                } while (!line.startsWith("}"));
                if (!blockValid) continue;
                br.reset();
                BSPEntity entity = null;
                if (classname.startsWith("worldspawn")) {
                    entity = new BSPEntity_worldspawn(classname);
                } else if (classname.startsWith("info_")) {
                    entity = new BSPEntity_info(classname);
                } else if (classname.startsWith("weapon_")) {
                    entity = new BSPEntity_weapon(classname);
                } else if (classname.startsWith("ammo_")) {
                    entity = new BSPEntity_ammo(classname);
                } else if (classname.startsWith("item_")) {
                    entity = new BSPEntity_item(classname);
                } else if (classname.startsWith("holdable_teleporter")) {
                    entity = new BSPEntity_Location(classname);
                } else if (classname.startsWith("misc_model")) {
                    entity = new BSPEntity_misc_model(classname);
                } else if (classname.startsWith("light")) {
                    entity = new BSPEntity_light(classname);
                } else if (classname.startsWith("func_")) {
                    if (classname.startsWith("func_pushable")) {
                        entity = new BSPEntity_func_pushable(classname);
                    } else if (classname.startsWith("func_plat")) {
                        entity = new BSPEntity_func_plat(classname);
                    } else if (classname.startsWith("func_ladder")) {
                        entity = new BSPEntity_func_ladder(classname);
                    } else if (classname.startsWith("func_wall")) {
                        entity = new BSPEntity_func_wall(classname);
                    }
                } else if (classname.startsWith("infodecal")) {
                    entity = new BSPEntity_decal_texture(classname);
                } else if (classname.startsWith("target_")) {
                    if (classname.startsWith("target_push")) {
                        entity = new BSPEntity_target_push(classname);
                    } else if (classname.startsWith("target_position")) {
                        entity = new BSPEntity_target_position(classname);
                    }
                } else if (classname.startsWith("trigger_")) {
                    if (classname.startsWith("trigger_multiple")) {
                        entity = new BSPEntity_trigger_multiple(classname);
                    }
                } else {
                    new BSPEntity_unknwown(classname).parse(br);
                }
                if (entity == null) continue;
                entity.parse(br);
                entities.add((BSPEntity_worldspawn)entity);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return entities.toArray(new BSPEntity[entities.size()]);
    }

    public static abstract class BSPEntity {
        public final String className;
        public final String className2;

        protected String getFieldsString() {
            return "    className = " + BSPEntitiesParser.qs(this.className) + "\n" + "    className2 = " + BSPEntitiesParser.qs(this.className2) + "\n";
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "\n{\n" + this.getFieldsString() + "}";
        }

        protected static final String parseLineValue(String line) {
            int spacePos = line.indexOf("\" \"");
            if (spacePos < 0) {
                return null;
            }
            return line.substring(spacePos + 3, line.length() - 1);
        }

        protected abstract void parseLine(String var1);

        protected void parse(BufferedReader br) throws IOException {
            String line;
            while ((line = br.readLine()).indexOf("}") < 0) {
                if (line.length() <= 0) continue;
                this.parseLine(line);
            }
        }

        public BSPEntity(String className, String className2) {
            this.className = className;
            this.className2 = className2;
        }
    }

    public static class BSPEntity_Location
    extends BSPEntity {
        public Point3f origin;
        public Tuple3f angles = new Tuple3f(0.0f, 0.0f, 0.0f);

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    origin = " + this.origin + "\n" + "    angles = " + this.angles + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"origin\"")) {
                String[] v = BSPEntity_Location.parseLineValue(line).split(" ");
                this.origin = new Point3f(Float.parseFloat(v[0]), Float.parseFloat(v[1]), Float.parseFloat(v[2]));
            } else if (line.startsWith("\"angles\"")) {
                String[] v = BSPEntity_Location.parseLineValue(line).split(" ");
                this.angles.set(Float.parseFloat(v[0]), Float.parseFloat(v[1]), Float.parseFloat(v[2]));
            } else if (line.startsWith("\"angle\"")) {
                this.angles.set(0.0f, Float.parseFloat(BSPEntity_Location.parseLineValue(line)), 0.0f);
            }
        }

        public BSPEntity_Location(String className2) {
            super("location", className2);
        }

        public BSPEntity_Location(String className, String className2) {
            super(className, className2);
        }
    }

    public static class BSPEntity_ammo
    extends BSPEntity_Location {
        protected String getFieldsString() {
            return super.getFieldsString();
        }

        protected void parseLine(String line) {
            super.parseLine(line);
        }

        public BSPEntity_ammo(String className2) {
            super("ammo", className2);
        }
    }

    public static class BSPEntity_decal_texture
    extends BSPEntity {
        public Point3f origin;
        public String texture;
        public float angle;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    origin = " + this.origin + "\n" + "    texture = " + BSPEntitiesParser.qs(this.texture) + "\n" + "    angle = " + this.angle + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"origin\"")) {
                String[] v = BSPEntity_decal_texture.parseLineValue(line).split(" ");
                this.origin = new Point3f(Float.parseFloat(v[0]), Float.parseFloat(v[1]), Float.parseFloat(v[2]));
            } else if (line.startsWith("\"texture\"")) {
                this.texture = BSPEntity_decal_texture.parseLineValue(line);
            } else if (line.startsWith("\"angle\"")) {
                this.angle = Float.parseFloat(BSPEntity_decal_texture.parseLineValue(line));
            }
        }

        public BSPEntity_decal_texture(String className2) {
            super("decal_texture", className2);
        }
    }

    public static class BSPEntity_func_ladder
    extends BSPEntity {
        public String model;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    model = " + BSPEntitiesParser.qs(this.model) + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"model\"")) {
                this.model = BSPEntity_func_ladder.parseLineValue(line);
            }
        }

        public BSPEntity_func_ladder(String className2) {
            super("func_ladder", className2);
        }
    }

    public static class BSPEntity_func_plat
    extends BSPEntity {
        public String model;
        public int _minLight;
        public int height;
        public float volume;
        public int stopSound;
        public int moveSound;
        public Colorf renderColor;
        public int renderAMT;
        public int renderMode;
        public int renderFX;
        public float angle;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    model = " + BSPEntitiesParser.qs(this.model) + "\n" + "    _minLight = " + this._minLight + "\n" + "    height = " + this.height + "\n" + "    volume = " + this.volume + "\n" + "    stopSound = " + this.stopSound + "\n" + "    moveSound = " + this.moveSound + "\n" + "    renderColor = " + this.renderColor + "\n" + "    renderAMT = " + this.renderAMT + "\n" + "    renderMode = " + this.renderMode + "\n" + "    renderFX = " + this.renderFX + "\n" + "    angle = " + this.angle + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"model\"")) {
                this.model = BSPEntity_func_plat.parseLineValue(line);
            } else if (line.startsWith("\"_minlight\"")) {
                this._minLight = Integer.parseInt(BSPEntity_func_plat.parseLineValue(line));
            } else if (line.startsWith("\"height\"")) {
                this.height = Integer.parseInt(BSPEntity_func_plat.parseLineValue(line));
            } else if (line.startsWith("\"volume\"")) {
                this.volume = Float.parseFloat(BSPEntity_func_plat.parseLineValue(line));
            } else if (line.startsWith("\"stopsnd\"")) {
                this.stopSound = Integer.parseInt(BSPEntity_func_plat.parseLineValue(line));
            } else if (line.startsWith("\"movesnd\"")) {
                this.moveSound = Integer.parseInt(BSPEntity_func_plat.parseLineValue(line));
            } else if (line.startsWith("\"rendercolor\"")) {
                String[] v = BSPEntity_func_plat.parseLineValue(line).split(" ");
                this.renderColor = new Colorf(Float.parseFloat(v[0]) / 255.0f, Float.parseFloat(v[1]) / 255.0f, Float.parseFloat(v[2]) / 255.0f);
            } else if (line.startsWith("\"renderamt\"")) {
                this.renderAMT = Integer.parseInt(BSPEntity_func_plat.parseLineValue(line));
            } else if (line.startsWith("\"rendermode\"")) {
                this.renderMode = Integer.parseInt(BSPEntity_func_plat.parseLineValue(line));
            } else if (line.startsWith("\"renderfx\"")) {
                this.renderFX = Integer.parseInt(BSPEntity_func_plat.parseLineValue(line));
            } else if (line.startsWith("\"angle\"")) {
                this.angle = Float.parseFloat(BSPEntity_func_plat.parseLineValue(line));
            }
        }

        public BSPEntity_func_plat(String className2) {
            super("func_plat", className2);
        }
    }

    public static class BSPEntity_func_pushable
    extends BSPEntity {
        public String model;
        public int delay;
        public int explosion;
        public int material;
        public int health;
        public int renderMode;
        public int renderFX;
        public int buoyancy;
        public int friction;
        public int size;
        public Colorf renderColor;
        public int renderAMT;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    model = " + BSPEntitiesParser.qs(this.model) + "\n" + "    delay = " + this.delay + "\n" + "    explosion = " + this.explosion + "\n" + "    material = " + this.material + "\n" + "    health = " + this.health + "\n" + "    renderMode = " + this.renderMode + "\n" + "    renderFX = " + this.renderFX + "\n" + "    buoyancy = " + this.buoyancy + "\n" + "    friction = " + this.friction + "\n" + "    size = " + this.size + "\n" + "    renderColor = " + this.renderColor + "\n" + "    renderAMT = " + this.renderAMT + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"model\"")) {
                this.model = BSPEntity_func_pushable.parseLineValue(line);
            } else if (line.startsWith("\"delay\"")) {
                this.delay = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"explosion\"")) {
                this.explosion = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"material\"")) {
                this.material = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"health\"")) {
                this.health = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"rendermode\"")) {
                this.renderMode = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"renderfx\"")) {
                this.renderFX = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"buoyancy\"")) {
                this.buoyancy = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"friction\"")) {
                this.friction = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"size\"")) {
                this.size = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            } else if (line.startsWith("\"rendercolor\"")) {
                String[] v = BSPEntity_func_pushable.parseLineValue(line).split(" ");
                if (v.length == 3) {
                    this.renderColor = new Colorf(Float.parseFloat(v[0]) / 255.0f, Float.parseFloat(v[1]) / 255.0f, Float.parseFloat(v[2]) / 255.0f);
                } else {
                    float value = Float.parseFloat(v[0]) / 255.0f;
                    this.renderColor = new Colorf(value, value, value);
                }
            } else if (line.startsWith("\"renderamt\"")) {
                this.renderAMT = Integer.parseInt(BSPEntity_func_pushable.parseLineValue(line));
            }
        }

        public BSPEntity_func_pushable(String className2) {
            super("func_pushable", className2);
        }
    }

    public static class BSPEntity_func_wall
    extends BSPEntity {
        public String model;
        public Colorf renderColor;
        public int renderAMT;
        public int renderMode;
        public int renderFX;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    model = " + BSPEntitiesParser.qs(this.model) + "\n" + "    renderColor = " + this.renderColor + "\n" + "    renderAMT = " + this.renderAMT + "\n" + "    renderMode = " + this.renderMode + "\n" + "    renderFX = " + this.renderFX + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"model\"")) {
                this.model = BSPEntity_func_wall.parseLineValue(line);
            } else if (line.startsWith("\"rendercolor\"")) {
                String[] v = BSPEntity_func_wall.parseLineValue(line).split(" ");
                if (v.length == 3) {
                    this.renderColor = new Colorf(Float.parseFloat(v[0]) / 255.0f, Float.parseFloat(v[1]) / 255.0f, Float.parseFloat(v[2]) / 255.0f);
                } else {
                    float value = Float.parseFloat(v[0]) / 255.0f;
                    this.renderColor = new Colorf(value, value, value);
                }
            } else if (line.startsWith("\"renderamt\"")) {
                this.renderAMT = Integer.parseInt(BSPEntity_func_wall.parseLineValue(line));
            } else if (line.startsWith("\"rendermode\"")) {
                this.renderMode = Integer.parseInt(BSPEntity_func_wall.parseLineValue(line));
            } else if (line.startsWith("\"renderfx\"")) {
                this.renderFX = Integer.parseInt(BSPEntity_func_wall.parseLineValue(line));
            }
        }

        public BSPEntity_func_wall(String className2) {
            super("func_wall", className2);
        }
    }

    public static class BSPEntity_info
    extends BSPEntity_Location {
        protected String getFieldsString() {
            return super.getFieldsString();
        }

        protected void parseLine(String line) {
            super.parseLine(line);
        }

        public BSPEntity_info(String className2) {
            super("info", className2);
        }
    }

    public static class BSPEntity_item
    extends BSPEntity_Location {
        protected String getFieldsString() {
            return super.getFieldsString();
        }

        protected void parseLine(String line) {
            super.parseLine(line);
        }

        public BSPEntity_item(String className2) {
            super("item", className2);
        }
    }

    public static class BSPEntity_light
    extends BSPEntity {
        public Point3f origin;
        public int style = -1;
        public Colorf lightColor;
        public float _light;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    origin = " + this.origin + "\n" + "    style = " + this.style + "\n" + "    lightColor = " + this.lightColor + "\n" + "    _light = " + this._light + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"origin\"")) {
                String[] v = BSPEntity_light.parseLineValue(line).split(" ");
                this.origin = new Point3f(Float.parseFloat(v[0]), Float.parseFloat(v[1]), Float.parseFloat(v[2]));
            } else if (line.startsWith("\"style\"")) {
                this.style = Integer.parseInt(BSPEntity_light.parseLineValue(line));
            } else if (line.startsWith("\"_color\"")) {
                String[] v = BSPEntity_light.parseLineValue(line).split(" ");
                this.lightColor = new Colorf(Float.parseFloat(v[0]), Float.parseFloat(v[1]), Float.parseFloat(v[2]));
            } else if (line.startsWith("\"light\"")) {
                this._light = Float.parseFloat(BSPEntity_light.parseLineValue(line));
            } else if (line.startsWith("\"_light\"")) {
                String[] v = BSPEntity_light.parseLineValue(line).split(" ");
                this.lightColor = new Colorf(Float.parseFloat(v[0]) / 255.0f, Float.parseFloat(v[1]) / 255.0f, Float.parseFloat(v[2]) / 255.0f);
                if (v.length > 3) {
                    this._light = Float.parseFloat(v[3]);
                }
            }
        }

        public BSPEntity_light(String className2) {
            super("light", className2);
        }
    }

    public static class BSPEntity_misc_model
    extends BSPEntity_Location {
        public String model;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    model = " + BSPEntitiesParser.qs(this.model) + "\n";
        }

        protected void parseLine(String line) {
            super.parseLine(line);
            if (line.startsWith("\"model\"")) {
                this.model = BSPEntity_misc_model.parseLineValue(line);
            }
        }

        public BSPEntity_misc_model(String className2) {
            super("misc_model", className2);
        }
    }

    public static abstract class BSPEntity_target
    extends BSPEntity {
        public Point3f origin;
        public String targetName;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    origin = " + this.origin + "\n" + "    targetName = " + BSPEntitiesParser.qs(this.targetName) + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"origin\"")) {
                String[] v = BSPEntity_target.parseLineValue(line).split(" ");
                this.origin = new Point3f(Float.parseFloat(v[0]), Float.parseFloat(v[1]), Float.parseFloat(v[2]));
            } else if (line.startsWith("\"targetname\"")) {
                this.targetName = BSPEntity_target.parseLineValue(line);
            }
        }

        public BSPEntity_target(String className, String className2) {
            super(className, className2);
        }
    }

    public static class BSPEntity_target_position
    extends BSPEntity_target {
        protected String getFieldsString() {
            return super.getFieldsString();
        }

        protected void parseLine(String line) {
            super.parseLine(line);
        }

        public BSPEntity_target_position(String className2) {
            super("target_position", className2);
        }
    }

    public static class BSPEntity_target_push
    extends BSPEntity_target {
        public String target;
        public int spawnFlags;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    target = " + BSPEntitiesParser.qs(this.target) + "\n" + "    spawnFlags = " + this.spawnFlags + "\n";
        }

        protected void parseLine(String line) {
            super.parseLine(line);
            if (line.startsWith("\"target\"")) {
                this.target = BSPEntity_target_push.parseLineValue(line);
            } else if (line.startsWith("\"spawnflags\"")) {
                this.spawnFlags = Integer.parseInt(BSPEntity_target_push.parseLineValue(line));
            }
        }

        public BSPEntity_target_push(String className2) {
            super("target_push", className2);
        }
    }

    public static abstract class BSPEntity_trigger
    extends BSPEntity {
        protected String getFieldsString() {
            return super.getFieldsString();
        }

        protected void parseLine(String line) {
            BSPEntity.parseLineValue(line);
        }

        public BSPEntity_trigger(String className, String className2) {
            super(className, className2);
        }
    }

    public static class BSPEntity_trigger_multiple
    extends BSPEntity_trigger {
        public String model;

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    model = " + BSPEntitiesParser.qs(this.model) + "\n";
        }

        protected void parseLine(String line) {
            super.parseLine(line);
            if (line.startsWith("\"model\"")) {
                this.model = BSPEntity_trigger_multiple.parseLineValue(line);
            }
        }

        public BSPEntity_trigger_multiple(String className2) {
            super("trigger_multiple", className2);
        }
    }

    public static class BSPEntity_unknwown
    extends BSPEntity {
        protected void parseLine(String line) {
        }

        public BSPEntity_unknwown(String className2) {
            super("unknown", className2);
        }
    }

    public static class BSPEntity_weapon
    extends BSPEntity_Location {
        protected String getFieldsString() {
            return super.getFieldsString();
        }

        protected void parseLine(String line) {
            super.parseLine(line);
        }

        public BSPEntity_weapon(String className2) {
            super("weapon", className2);
        }
    }

    public static class BSPEntity_worldspawn
    extends BSPEntity {
        public String[] wadsFull;
        public String[] wads;
        public String chapterTitle;
        public String skyName = null;
        public String message = null;
        public int gameTitle;
        public int startDark;
        public int maxRange;
        public int light;
        public int sounds;

        private String getWadsFullString() {
            if (this.wadsFull == null) {
                return null;
            }
            String s = "{ ";
            int i = 0;
            while (i < this.wadsFull.length) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + BSPEntitiesParser.qs(this.wadsFull[i]);
                ++i;
            }
            s = String.valueOf(s) + " }";
            return s;
        }

        private String getWadsString() {
            if (this.wads == null) {
                return null;
            }
            String s = "{ ";
            int i = 0;
            while (i < this.wads.length) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + BSPEntitiesParser.qs(this.wads[i]);
                ++i;
            }
            s = String.valueOf(s) + " }";
            return s;
        }

        protected String getFieldsString() {
            return String.valueOf(super.getFieldsString()) + "    wadsFull = " + this.getWadsFullString() + "\n" + "    wads = " + this.getWadsString() + "\n" + "    chapterTitle = " + BSPEntitiesParser.qs(this.chapterTitle) + "\n" + "    skyName = " + BSPEntitiesParser.qs(this.skyName) + "\n" + "    message = " + BSPEntitiesParser.qs(this.message) + "\n" + "    gameTitle = " + this.gameTitle + "\n" + "    startDark = " + this.startDark + "\n" + "    maxRange = " + this.maxRange + "\n" + "    light = " + this.light + "\n" + "    sounds = " + this.sounds + "\n";
        }

        protected void parseLine(String line) {
            if (line.startsWith("\"wad\"")) {
                this.wadsFull = BSPEntity_worldspawn.parseLineValue(line).split(";");
                this.wads = new String[this.wadsFull.length];
                int i = 0;
                while (i < this.wadsFull.length) {
                    this.wadsFull[i] = this.wadsFull[i].replace('\\', '/');
                    int lastSlashPos = this.wadsFull[i].lastIndexOf(47);
                    this.wads[i] = lastSlashPos >= 0 ? this.wadsFull[i].substring(lastSlashPos + 1) : this.wadsFull[i];
                    ++i;
                }
            } else if (line.startsWith("\"chaptertitle\"")) {
                this.chapterTitle = BSPEntity_worldspawn.parseLineValue(line);
            } else if (line.startsWith("\"skyname\"")) {
                this.skyName = BSPEntity_worldspawn.parseLineValue(line);
            } else if (line.startsWith("\"message\"")) {
                this.message = BSPEntity_worldspawn.parseLineValue(line);
            } else if (line.startsWith("\"gametitle\"")) {
                this.gameTitle = Integer.parseInt(BSPEntity_worldspawn.parseLineValue(line));
            } else if (line.startsWith("\"startdark\"")) {
                this.startDark = Integer.parseInt(BSPEntity_worldspawn.parseLineValue(line));
            } else if (line.startsWith("\"MaxRange\"")) {
                this.maxRange = Integer.parseInt(BSPEntity_worldspawn.parseLineValue(line));
            } else if (line.startsWith("\"linght\"")) {
                this.light = Integer.parseInt(BSPEntity_worldspawn.parseLineValue(line));
            } else if (line.startsWith("\"sounds\"")) {
                this.sounds = Integer.parseInt(BSPEntity_worldspawn.parseLineValue(line));
            }
        }

        public BSPEntity_worldspawn(String className2) {
            super("worldspawn", className2);
        }
    }
}

