/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jagatoo.loaders.models.bsp.lumps.BSPLump;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.streams.StreamUtils;

class BSPFile {
    private final URL baseURL;
    private final BufferedInputStream in;
    private final String filename;
    private char[] ID;
    private int version;
    protected BSPLump[] lumps;

    public final String getName() {
        return this.filename;
    }

    public final URL getBaseURL() {
        return this.baseURL;
    }

    public final BufferedInputStream getInputStrema() {
        return this.in;
    }

    public final void resetPointer() throws IOException {
        this.in.reset();
    }

    public final void seek(int lump) throws IOException {
        this.in.reset();
        long toSkip = this.lumps[lump].offset;
        StreamUtils.skipBytes(this.in, toSkip);
    }

    public final void skipBytes(int numBytes) throws IOException {
        StreamUtils.skipBytes(this.in, (long)numBytes);
    }

    public final byte readByte() throws IOException {
        return (byte)this.in.read();
    }

    public final char readChar() throws IOException {
        return (char)this.readByte();
    }

    public final int readInt() throws IOException {
        return StreamUtils.readSwappedInt(this.in);
    }

    public final short readShort() throws IOException {
        return StreamUtils.readSwappedShort(this.in);
    }

    public final int readUnsignedShort() throws IOException {
        return StreamUtils.readSwappedUnsignedShort(this.in);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(StreamUtils.readSwappedInt(this.in));
    }

    public final void readFully(byte[] data) throws IOException {
        this.in.read(data);
    }

    public final void readFully(byte[] data, int offset, int length) throws IOException {
        this.in.read(data, offset, length);
    }

    public final byte[] readFully(int count) throws IOException {
        byte[] data = new byte[count];
        this.in.read(data);
        return data;
    }

    public final void readFully(char[] data, int count) throws IOException {
        int i = 0;
        while (i < count) {
            data[i] = this.readChar();
            ++i;
        }
    }

    protected final void readDirectory() throws IOException {
        int lumpCount;
        switch (this.version) {
            case 46: {
                lumpCount = 17;
                break;
            }
            default: {
                lumpCount = 15;
            }
        }
        this.lumps = new BSPLump[lumpCount];
        int i = 0;
        while (i < lumpCount) {
            this.lumps[i] = new BSPLump();
            this.lumps[i].offset = this.readInt();
            this.lumps[i].length = this.readInt();
            ++i;
        }
    }

    public final void close() throws IOException {
        this.in.close();
    }

    public final char[] getID() {
        return this.ID;
    }

    public final int getVersion() {
        return this.version;
    }

    private void checkVersion(int version) throws IncorrectFormatException {
        if (version != 46 && version != 30) {
            String errorCodeString = "Unable to read ";
            switch (version) {
                case 29: {
                    errorCodeString = String.valueOf(errorCodeString) + "Quake1 BSP file. version = " + version;
                    break;
                }
                case 38: {
                    errorCodeString = String.valueOf(errorCodeString) + "Quake2 BSP file. ID = " + new String(this.ID) + " - version = " + version;
                    break;
                }
                case 19: 
                case 20: {
                    errorCodeString = String.valueOf(errorCodeString) + "Half-Life2 BSP file. ID = " + new String(this.ID) + " - version = " + version;
                    break;
                }
                default: {
                    errorCodeString = "Unknown BSP version number or BSP format.";
                }
            }
            throw new IncorrectFormatException(errorCodeString);
        }
    }

    private void checkHeader() throws IOException, IncorrectFormatException {
        this.ID = new char[4];
        this.ID[0] = this.readChar();
        this.ID[1] = this.readChar();
        this.ID[2] = this.readChar();
        this.ID[3] = this.readChar();
        if (!new String(this.ID).substring(1).equals("BSP")) {
            this.resetPointer();
        }
        this.version = this.readInt();
        this.checkVersion(this.version);
    }

    protected BSPFile(InputStream in, String filename, URL baseURL) throws IOException {
        this.filename = filename;
        this.baseURL = baseURL;
        this.in = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        this.in.mark(Integer.MAX_VALUE);
        this.checkHeader();
        this.readDirectory();
    }
}

