/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models.bsp.BSPFile;
import org.jagatoo.loaders.models.bsp.BSPPrototypeLoader;
import org.jagatoo.loaders.models.bsp.BSPScenePrototype;
import org.jagatoo.loaders.models.bsp.BSPVersionDataLoader;
import org.jagatoo.loaders.models.bsp.lumps.BSP30Model;
import org.jagatoo.loaders.models.bsp.lumps.BSPDirectory;
import org.jagatoo.loaders.models.bsp.lumps.BSPEdge;
import org.jagatoo.loaders.models.bsp.lumps.BSPFace;
import org.jagatoo.loaders.models.bsp.lumps.BSPTexInfo;
import org.jagatoo.loaders.models.bsp.lumps.BSPVertex;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.openmali.FastMath;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class BSPVersionDataLoader30
implements BSPVersionDataLoader {
    public static byte[] decompressVis(int numLeafs, byte[] compressed) {
        byte[] decompressed = null;
        return decompressed;
    }

    public BSPScenePrototype loadPrototypeData(BSPFile bspFile, BSPDirectory bspDir, float worldScale, AppearanceFactory appFactory) throws IOException, IncorrectFormatException, ParsingException {
        BSPScenePrototype prototype = new BSPScenePrototype(bspFile.getVersion());
        try {
            prototype.entities = BSPPrototypeLoader.readEntities(bspFile, bspDir);
            prototype.wadFiles = BSPPrototypeLoader.readWADFiles(bspFile, prototype.entities);
            prototype.planes = BSPPrototypeLoader.readPlanes(bspFile, bspDir, worldScale);
            prototype.baseTextures = BSPPrototypeLoader.readTextures(bspFile, bspDir, prototype.wadFiles, prototype.entities, appFactory);
            prototype.vertices = BSPPrototypeLoader.readVertices(bspFile, bspDir);
            prototype.leafs = BSPPrototypeLoader.readLeafs(bspFile, bspDir);
            prototype.visData = BSPPrototypeLoader.readVisData(bspFile, bspDir, prototype.leafs.length);
            prototype.nodes = BSPPrototypeLoader.readNodes(bspFile, bspDir);
            prototype.texInfos = BSPPrototypeLoader.readTexInfos(bspFile, bspDir);
            prototype.faces = BSPPrototypeLoader.readFaces(bspFile, bspDir);
            prototype.lightMaps = new AbstractTexture[prototype.faces.length];
            prototype.lightMapData = BSPPrototypeLoader.readLightmapData(bspFile, bspDir);
            prototype.edges = BSPPrototypeLoader.readEdges(bspFile, bspDir);
            prototype.surfEdges = BSPPrototypeLoader.readSurfEdges(bspFile, bspDir);
            prototype.models = BSPPrototypeLoader.readModels(bspFile, bspDir);
            bspFile.close();
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
        return prototype;
    }

    private static final void calcNormals(BSPVertex[] vertices, boolean convertZup2Yup) {
        Vector3f v1 = Vector3f.fromPool();
        Vector3f v2 = Vector3f.fromPool();
        int i = 1;
        while (i < vertices.length - 1) {
            v1.sub((TupleNf)vertices[0].position, (TupleNf)vertices[i].position);
            v2.sub((TupleNf)vertices[i + 1].position, (TupleNf)vertices[i].position);
            vertices[i].normal.cross(v1, v2).normalize();
            ++i;
        }
        v1.sub((TupleNf)vertices[vertices.length - 2].position, (TupleNf)vertices[vertices.length - 1].position);
        v2.sub((TupleNf)vertices[0].position, (TupleNf)vertices[vertices.length - 1].position);
        vertices[vertices.length - 1].normal.cross(v1, v2).normalize();
        vertices[0].normal.setZero();
        i = 1;
        while (i < vertices.length) {
            if (convertZup2Yup) {
                vertices[i].normal.set(vertices[i].normal.getX(), vertices[i].normal.getZ(), -vertices[i].normal.getY());
            }
            vertices[0].normal.add((TupleNf)vertices[i].normal);
            ++i;
        }
        vertices[0].normal.div((float)(vertices.length - 1));
        vertices[0].normal.normalize();
        Vector3f.toPool((Vector3f)v2);
        Vector3f.toPool((Vector3f)v1);
    }

    private NamedObject convertFaceToGeometry(int faceIndex, BSPFace face, int[] surfEdges, BSPEdge[] bspEdges, BSPVertex[] vertices, BSPTexInfo[] texInfos, AbstractTexture[][] baseTextures, byte[] lightMapData, AbstractTexture[] lightMaps, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale) {
        int[] nArray;
        int numVertices = face.numOfVerts;
        BSPVertex[] control = new BSPVertex[numVertices];
        int j = 0;
        int i = 0;
        while (i < face.numOfVerts) {
            int sfIdx = surfEdges[face.vertexIndex + i];
            BSPVertex v0 = sfIdx >= 0 ? vertices[bspEdges[sfIdx].vindices[0]] : vertices[bspEdges[-sfIdx].vindices[1]];
            control[j++] = v0;
            ++i;
        }
        if (BSPPrototypeLoader.loadNormals) {
            BSPVersionDataLoader30.calcNormals(control, convertZup2Yup);
        }
        GeometryFactory.GeometryType geomType = GeometryFactory.GeometryType.TRIANGLE_FAN_ARRAY;
        face.lightmapID = -1;
        String string = "Geometry " + faceIndex;
        int n = 1 | (BSPPrototypeLoader.loadNormals ? 2 : 0) | 8;
        if (face.lightmapID >= 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 2;
            nArray = nArray2;
            nArray2[1] = 2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 2;
        }
        NamedObject ga = geomFactory.createInterleavedGeometry(string, geomType, 3, numVertices, 0, null, n, false, nArray, null);
        BSPTexInfo texInfo = texInfos[face.textureID];
        face.textureID = texInfo.textureID;
        Point3f p = Point3f.fromPool();
        float min_u = Float.MAX_VALUE;
        float max_u = -3.4028235E38f;
        float min_v = Float.MAX_VALUE;
        float max_v = -3.4028235E38f;
        int i2 = 0;
        while (i2 < numVertices) {
            p.set((TupleNf)control[i2].position);
            if (convertZup2Yup) {
                geomFactory.setCoordinate(ga, geomType, i2, p.getX() * worldScale, p.getZ() * worldScale, -p.getY() * worldScale);
            } else {
                geomFactory.setCoordinate(ga, geomType, i2, p.getX() * worldScale, p.getY() * worldScale, p.getZ() * worldScale);
            }
            if (BSPPrototypeLoader.loadNormals) {
                geomFactory.setNormal(ga, geomType, i2, control[i2].normal.getX(), control[i2].normal.getY(), control[i2].normal.getZ());
            }
            float u = p.getX() * texInfo.s[0] + p.getY() * texInfo.s[1] + p.getZ() * texInfo.s[2] + texInfo.s[3];
            float v = p.getX() * texInfo.t[0] + p.getY() * texInfo.t[1] + p.getZ() * texInfo.t[2] + texInfo.t[3];
            if (face.textureID >= 0) {
                int orgWidth = baseTextures[face.textureID][0].getImage(0).getOriginalWidth();
                int orgHeight = baseTextures[face.textureID][0].getImage(0).getOriginalHeight();
                u /= (float)orgWidth;
                v /= (float)orgHeight;
            }
            if (u < min_u) {
                min_u = u;
            }
            if (u > max_u) {
                max_u = u;
            }
            if (v < min_v) {
                min_v = v;
            }
            if (v > max_v) {
                max_v = v;
            }
            geomFactory.setTexCoord(ga, geomType, 0, i2, u, v);
            ++i2;
        }
        Point3f.toPool((Point3f)p);
        if (face.lightmapID >= 0) {
            int lightMapWidth = (int)FastMath.ceil((float)(max_u / 16.0f)) - (int)FastMath.floor((float)(min_u / 16.0f)) + 1;
            int lightMapHeight = (int)FastMath.ceil((float)(max_v / 16.0f)) - (int)FastMath.floor((float)(min_v / 16.0f)) + 1;
            int lightMapDataOffset = face.lightmapID;
            face.lightmapID = faceIndex;
            AbstractTextureImage texImg0 = appFactory.createTextureImage(TextureImageFormat.RGB, lightMapWidth, lightMapHeight);
            ByteBuffer bb = texImg0.getDataBuffer();
            bb.position(0);
            bb.put(lightMapData, lightMapDataOffset, lightMapWidth * lightMapHeight * 3);
            bb.flip();
            lightMaps[faceIndex] = appFactory.createTexture(texImg0, true);
            int i3 = 0;
            while (i3 < numVertices) {
                p = control[i3].position;
                float u = p.getX() * texInfo.s[0] + p.getY() * texInfo.s[1] + p.getZ() * texInfo.s[2] + texInfo.s[3];
                float v = p.getX() * texInfo.t[0] + p.getY() * texInfo.t[1] + p.getZ() * texInfo.t[2] + texInfo.t[3];
                geomFactory.setTexCoord(ga, geomType, 1, i3, u /= (float)lightMapWidth, v /= (float)lightMapHeight);
                ++i3;
            }
        }
        geomFactory.finalizeGeometry(ga, geomType, 0, numVertices, 0, 0);
        return ga;
    }

    public void convertFacesToGeometries(BSPScenePrototype prototype, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale) {
        int numModels = prototype.models.length;
        prototype.geometries = new NamedObject[numModels][];
        int m = 0;
        while (m < numModels) {
            BSP30Model model = (BSP30Model)prototype.models[m];
            int numFaces = model.numOfFaces;
            NamedObject[] geometries = new NamedObject[numFaces];
            int f = 0;
            while (f < numFaces) {
                geometries[f] = this.convertFaceToGeometry(f, prototype.faces[model.faceIndex + f], prototype.surfEdges, prototype.edges, prototype.vertices, prototype.texInfos, prototype.baseTextures, prototype.lightMapData, prototype.lightMaps, appFactory, geomFactory, convertZup2Yup, worldScale);
                ++f;
            }
            prototype.geometries[m] = geometries;
            ++m;
        }
    }
}

