/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import java.io.IOException;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models.bsp.BSPFile;
import org.jagatoo.loaders.models.bsp.BSPPrototypeLoader;
import org.jagatoo.loaders.models.bsp.BSPScenePrototype;
import org.jagatoo.loaders.models.bsp.BSPVersionDataLoader;
import org.jagatoo.loaders.models.bsp.lumps.BSP46Model;
import org.jagatoo.loaders.models.bsp.lumps.BSPDirectory;
import org.jagatoo.loaders.models.bsp.lumps.BSPFace;
import org.jagatoo.loaders.models.bsp.lumps.BSPVertex;
import org.jagatoo.loaders.models.bsp.util.PatchSurface;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.openmali.vecmath2.Vector3f;

public class BSPVersionDataLoader46
implements BSPVersionDataLoader {
    public BSPScenePrototype loadPrototypeData(BSPFile bspFile, BSPDirectory bspDir, float worldScale, AppearanceFactory appFactory) throws IOException, IncorrectFormatException, ParsingException {
        BSPScenePrototype prototype = new BSPScenePrototype(bspFile.getVersion());
        try {
            prototype.entities = BSPPrototypeLoader.readEntities(bspFile, bspDir);
            prototype.wadFiles = BSPPrototypeLoader.readWADFiles(bspFile, prototype.entities);
            prototype.baseTextures = BSPPrototypeLoader.readTextures(bspFile, bspDir, prototype.wadFiles, prototype.entities, appFactory);
            prototype.planes = BSPPrototypeLoader.readPlanes(bspFile, bspDir, worldScale);
            prototype.nodes = BSPPrototypeLoader.readNodes(bspFile, bspDir);
            prototype.leafs = BSPPrototypeLoader.readLeafs(bspFile, bspDir);
            prototype.leafFaces = BSPPrototypeLoader.readLeafFaces(bspFile, bspDir);
            prototype.models = BSPPrototypeLoader.readModels(bspFile, bspDir);
            prototype.brushes = BSPPrototypeLoader.readBrushes(bspFile, bspDir);
            prototype.brushSides = BSPPrototypeLoader.readBrushSides(bspFile, bspDir);
            prototype.vertices = BSPPrototypeLoader.readVertices(bspFile, bspDir);
            prototype.meshVertices = BSPPrototypeLoader.readMeshVertices(bspFile, bspDir);
            prototype.faces = BSPPrototypeLoader.readFaces(bspFile, bspDir);
            prototype.lightMaps = BSPPrototypeLoader.readLightmaps(bspFile, bspDir, appFactory);
            prototype.visData = BSPPrototypeLoader.readVisData(bspFile, bspDir, prototype.leafs.length);
            bspFile.close();
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
        return prototype;
    }

    private static final float[] getNormal(Vector3f normal, boolean convertZup2Yup) {
        if (convertZup2Yup) {
            return new float[]{normal.getX(), normal.getZ(), -normal.getY()};
        }
        return new float[]{normal.getX(), normal.getY(), normal.getZ()};
    }

    private NamedObject convertFaceToIndexedStripGeom(int faceIndex, BSPFace face, BSPVertex[] vertices, int[] meshVertices, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale) {
        GeometryFactory.GeometryType geomType = GeometryFactory.GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY;
        NamedObject ga = geomFactory.createInterleavedGeometry("Geometry " + faceIndex, geomType, 3, face.numOfVerts, face.numMeshVerts / 3 + 2, new int[]{face.numMeshVerts}, 1 | (BSPPrototypeLoader.loadNormals ? 2 : 0) | 8, false, new int[]{2, 2}, null);
        int i = 0;
        while (i < face.numOfVerts) {
            int j = face.vertexIndex + i;
            if (convertZup2Yup) {
                geomFactory.setCoordinate(ga, geomType, i, vertices[j].position.getX() * worldScale, vertices[j].position.getZ() * worldScale, -vertices[j].position.getY() * worldScale);
            } else {
                geomFactory.setCoordinate(ga, geomType, i, vertices[j].position.getX() * worldScale, vertices[j].position.getY() * worldScale, vertices[j].position.getZ() * worldScale);
            }
            if (BSPPrototypeLoader.loadNormals) {
                geomFactory.setNormals(ga, geomType, i, BSPVersionDataLoader46.getNormal(vertices[j].normal, convertZup2Yup), 0, 1);
            }
            geomFactory.setTexCoord(ga, geomType, 0, i, vertices[j].texCoord.getS(), vertices[j].texCoord.getT());
            geomFactory.setTexCoord(ga, geomType, 1, i, vertices[j].lightTexCoord.getS(), vertices[j].lightTexCoord.getT());
            ++i;
        }
        int[] index = new int[face.numMeshVerts / 3 + 2];
        int i2 = 0;
        while (i2 < face.numMeshVerts) {
            if (i2 < 3) {
                index[i2] = meshVertices[face.meshVertIndex + i2];
            } else if (i2 % 3 == 2) {
                index[2 + i2 / 3] = meshVertices[face.meshVertIndex + i2];
            }
            ++i2;
        }
        geomFactory.setIndex(ga, geomType, 0, index, 0, index.length);
        geomFactory.finalizeGeometry(ga, geomType, 0, face.numOfVerts, 0, index.length);
        return ga;
    }

    private NamedObject convertFaceToSurfacePatch(int faceIndex, BSPFace face, BSPVertex[] vertices, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale) {
        BSPVertex[] control = new BSPVertex[face.numOfVerts];
        int i = 0;
        while (i < face.numOfVerts) {
            control[i] = vertices[face.vertexIndex + i];
            ++i;
        }
        PatchSurface ps = new PatchSurface(control, face.size[0], face.size[1]);
        GeometryFactory.GeometryType geomType = GeometryFactory.GeometryType.INDEXED_TRIANGLE_ARRAY;
        NamedObject ga = geomFactory.createInterleavedGeometry("Geometry " + faceIndex, geomType, 3, ps.mPoints.length, ps.mIndices.length, null, 1 | (BSPPrototypeLoader.loadNormals ? 2 : 0) | 8, false, new int[]{2, 2}, null);
        int i2 = 0;
        while (i2 < ps.mPoints.length) {
            if (convertZup2Yup) {
                geomFactory.setCoordinate(ga, geomType, i2, ps.mPoints[i2].position.getX() * worldScale, ps.mPoints[i2].position.getZ() * worldScale, -ps.mPoints[i2].position.getY() * worldScale);
            } else {
                geomFactory.setCoordinate(ga, geomType, i2, ps.mPoints[i2].position.getX() * worldScale, ps.mPoints[i2].position.getY() * worldScale, ps.mPoints[i2].position.getZ() * worldScale);
            }
            if (BSPPrototypeLoader.loadNormals) {
                geomFactory.setNormals(ga, geomType, i2, BSPVersionDataLoader46.getNormal(ps.mPoints[i2].normal, convertZup2Yup), 0, 1);
            }
            geomFactory.setTexCoord(ga, geomType, 0, i2, ps.mPoints[i2].texCoord.getS(), ps.mPoints[i2].texCoord.getT());
            geomFactory.setTexCoord(ga, geomType, 1, i2, ps.mPoints[i2].lightTexCoord.getS(), ps.mPoints[i2].lightTexCoord.getT());
            ++i2;
        }
        geomFactory.setIndex(ga, geomType, 0, ps.mIndices, 0, ps.mIndices.length);
        geomFactory.finalizeGeometry(ga, geomType, 0, ps.mPoints.length, 0, ps.mIndices.length);
        return ga;
    }

    private NamedObject convertFaceToIndexedGeom(int faceIndex, BSPFace face, BSPVertex[] vertices, int[] meshVertices, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale) {
        GeometryFactory.GeometryType geomType = GeometryFactory.GeometryType.INDEXED_TRIANGLE_ARRAY;
        NamedObject ga = geomFactory.createInterleavedGeometry("Geometry " + faceIndex, geomType, 3, face.numOfVerts, face.numMeshVerts, null, 1 | (BSPPrototypeLoader.loadNormals ? 2 : 0) | 8, false, new int[]{2, 2}, null);
        int i = 0;
        while (i < face.numOfVerts) {
            int j = face.vertexIndex + i;
            if (convertZup2Yup) {
                geomFactory.setCoordinate(ga, geomType, i, vertices[j].position.getX() * worldScale, vertices[j].position.getZ() * worldScale, -vertices[j].position.getY() * worldScale);
            } else {
                geomFactory.setCoordinate(ga, geomType, i, vertices[j].position.getX() * worldScale, vertices[j].position.getY() * worldScale, vertices[j].position.getZ() * worldScale);
            }
            if (BSPPrototypeLoader.loadNormals) {
                geomFactory.setNormals(ga, geomType, i, BSPVersionDataLoader46.getNormal(vertices[j].normal, convertZup2Yup), 0, 1);
            }
            geomFactory.setTexCoord(ga, geomType, 0, i, vertices[j].texCoord.getS(), vertices[j].texCoord.getT());
            geomFactory.setTexCoord(ga, geomType, 1, i, vertices[j].lightTexCoord.getS(), vertices[j].lightTexCoord.getT());
            ++i;
        }
        int[] index = new int[face.numMeshVerts];
        System.arraycopy(meshVertices, face.meshVertIndex, index, 0, face.numMeshVerts);
        geomFactory.setIndex(ga, geomType, 0, index, 0, index.length);
        geomFactory.finalizeGeometry(ga, geomType, 0, face.numOfVerts, 0, index.length);
        return ga;
    }

    private NamedObject convertFaceToBillboard(int faceIndex, BSPFace face, BSPVertex[] vertices, int[] meshVertices, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale) {
        System.out.println("TODO: Implement the abstract creation of Billboard geometry");
        return null;
    }

    public NamedObject convertFaceToGeometry(int faceIndex, BSPFace face, BSPVertex[] vertices, int[] meshVertices, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale) {
        switch (face.type) {
            case 1: {
                return this.convertFaceToIndexedGeom(faceIndex, face, vertices, meshVertices, geomFactory, convertZup2Yup, worldScale);
            }
            case 2: {
                return this.convertFaceToSurfacePatch(faceIndex, face, vertices, geomFactory, convertZup2Yup, worldScale);
            }
            case 3: {
                return this.convertFaceToIndexedGeom(faceIndex, face, vertices, meshVertices, geomFactory, convertZup2Yup, worldScale);
            }
            case 4: {
                return this.convertFaceToBillboard(faceIndex, face, vertices, meshVertices, geomFactory, convertZup2Yup, worldScale);
            }
        }
        throw new Error("Unsupported face type " + face.type);
    }

    public void convertFacesToGeometries(BSPScenePrototype prototype, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float worldScale) {
        int numModels = prototype.models.length;
        prototype.geometries = new NamedObject[numModels][];
        int m = 0;
        while (m < numModels) {
            BSP46Model model = (BSP46Model)prototype.models[m];
            int numFaces = model.numOfFaces;
            NamedObject[] geometries = new NamedObject[numFaces];
            int f = 0;
            while (f < model.numOfFaces) {
                BSPFace face = prototype.faces[model.faceIndex + f];
                geometries[f] = this.convertFaceToGeometry(f, face, prototype.vertices, prototype.meshVertices, geomFactory, convertZup2Yup, worldScale);
                ++f;
            }
            prototype.geometries[m] = geometries;
            ++m;
        }
    }
}

