/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.jagatoo.image.BufferedImageFactory;
import org.jagatoo.image.SharedBufferedImage;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models.bsp.BSPEntitiesParser;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.jagatoo.util.image.ImageUtility;
import org.jagatoo.util.streams.StreamUtils;
import org.openmali.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WADFile {
    private static final int MAGIC_NUMBER_WAD3 = 1463895091;
    private final URL wadResource;
    private final String wadFilename;
    private int magicNumber;
    private String wadType;
    private final HashMap<String, WADDirectoryEntry> wadDir;

    public final String getWADFilename() {
        return this.wadFilename;
    }

    public final String getWadType() {
        return this.wadType;
    }

    public final int getLumpCount() {
        return this.wadDir.size();
    }

    public final String[] getWADResources() {
        Object[] result = new String[this.wadDir.size()];
        int i = 0;
        for (String s : this.wadDir.keySet()) {
            result[i] = s;
        }
        Arrays.sort(result);
        return result;
    }

    public final boolean containsResource(String resName) {
        return this.wadDir.containsKey(resName.toLowerCase());
    }

    public final BufferedInputStream getResourceAsStream(String resName) throws IOException {
        WADDirectoryEntry entry = this.wadDir.get(resName.toLowerCase());
        if (entry == null) {
            return null;
        }
        InputStream in = this.wadResource.openStream();
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        in.skip(entry.offset);
        return (BufferedInputStream)in;
    }

    public final void exportResource(String resName, String filename) throws IOException {
        WADDirectoryEntry entry = this.wadDir.get(resName.toLowerCase());
        if (entry == null) {
            throw new IOException("The resource was not found in this WAD file.");
        }
        InputStream in = this.wadResource.openStream();
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        in.skip(entry.offset);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
        int i = 0;
        while (i < entry.compFileSize) {
            out.write((byte)in.read());
            ++i;
        }
        out.close();
        in.close();
    }

    private static void transferScaledBytes(byte[] unscaledData, int bytesPerPixel, ByteBuffer bb, int orgWidth, int orgHeight, int width, int height) {
        SharedBufferedImage sbi = BufferedImageFactory.createSharedBufferedImage(orgWidth, orgHeight, bytesPerPixel, null, unscaledData);
        SharedBufferedImage sbi_scaled = ImageUtility.scaleImage(sbi, width, height, bytesPerPixel == 4);
        byte[] scaledData = sbi_scaled.getSharedData();
        int i = 0;
        while (i < scaledData.length) {
            bb.put(scaledData[i + 2]);
            bb.put(scaledData[i + 1]);
            bb.put(scaledData[i + 0]);
            if (bytesPerPixel == 4) {
                bb.put(scaledData[i + 3]);
            }
            i += bytesPerPixel;
        }
    }

    private void readTransparentTexture(DataInputStream din, byte[][] palette, int orgWidth, int orgHeight, int width, int height, ByteBuffer bb, byte[] pixelData) throws IOException {
        boolean needsPostScaling = pixelData != null;
        int size = orgWidth * orgHeight;
        int pos = 0;
        int i = 0;
        while (i < size) {
            int palIdx = din.read();
            byte r = palette[palIdx][0];
            byte g = palette[palIdx][1];
            byte b = palette[palIdx][2];
            byte a = -1;
            if (r == 0 && g == 0 && b == -1) {
                r = 0;
                b = 0;
                g = 0;
                a = 0;
            }
            if (!needsPostScaling) {
                bb.put(r);
                bb.put(g);
                bb.put(b);
                bb.put(a);
            } else {
                pixelData[pos + 2] = r;
                pixelData[pos + 1] = g;
                pixelData[pos + 0] = b;
                pixelData[pos + 3] = a;
                pos += 4;
            }
            ++i;
        }
        if (needsPostScaling) {
            WADFile.transferScaledBytes(pixelData, 4, bb, orgWidth, orgHeight, width, height);
        }
    }

    private void readGlassTexture(DataInputStream din, byte[][] palette, int orgWidth, int orgHeight, int width, int height, ByteBuffer bb, byte[] pixelData) throws IOException {
        boolean needsPostScaling = pixelData != null;
        int size = orgWidth * orgHeight;
        int pos = 0;
        int i = 0;
        while (i < size) {
            int palIdx = din.read();
            byte r = palette[palIdx][0];
            byte g = palette[palIdx][1];
            byte b = palette[palIdx][2];
            byte a = 127;
            if (!needsPostScaling) {
                bb.put(r);
                bb.put(g);
                bb.put(b);
                bb.put(a);
            } else {
                pixelData[pos + 2] = r;
                pixelData[pos + 1] = g;
                pixelData[pos + 0] = b;
                pixelData[pos + 3] = a;
                pos += 4;
            }
            ++i;
        }
        if (needsPostScaling) {
            WADFile.transferScaledBytes(pixelData, 4, bb, orgWidth, orgHeight, width, height);
        }
    }

    private void flipTextureHorizontally(AbstractTextureImage ti) {
        int pixelSize = ti.getPixelSize();
        int w = ti.getWidth();
        int wh = w / 2;
        int lineSize = w * pixelSize;
        int h = ti.getHeight();
        ByteBuffer bb = ti.getDataBuffer();
        int pos0 = bb.position();
        int limit0 = bb.limit();
        byte[] pixel1 = new byte[pixelSize];
        byte[] pixel2 = new byte[pixelSize];
        int y = 0;
        while (y < h) {
            int posBase = y * lineSize;
            int x = 0;
            while (x < wh) {
                int pos1 = posBase + x * pixelSize;
                int pos2 = posBase + lineSize - x * pixelSize - pixelSize;
                bb.position(pos0 + pos1);
                bb.get(pixel1, 0, pixelSize);
                bb.position(pos0 + pos2);
                bb.get(pixel2, 0, pixelSize);
                bb.position(pos0 + pos1);
                bb.put(pixel2, 0, pixelSize);
                bb.position(pos0 + pos2);
                bb.put(pixel1, 0, pixelSize);
                ++x;
            }
            ++y;
        }
        bb.position(pos0);
        bb.limit(limit0);
    }

    private void rotateTextureBy90Degree(AbstractTextureImage ti) {
        int pixelSize = ti.getPixelSize();
        int w = ti.getWidth();
        int lineSize = w * pixelSize;
        int h = ti.getHeight();
        ByteBuffer bb = ti.getDataBuffer();
        int pos0 = bb.position();
        int limit0 = bb.limit();
        byte[] pixel = new byte[pixelSize];
        byte[] bytes = new byte[h * lineSize];
        int y = 0;
        while (y < h) {
            int posBase = y * lineSize;
            int x = 0;
            while (x < w) {
                int pos1 = posBase + x * pixelSize;
                int x2 = y;
                int y2 = h - 1 - x;
                int pos2 = y2 * lineSize + x2 * pixelSize;
                bb.position(pos0 + pos1);
                bb.get(pixel, 0, pixelSize);
                System.arraycopy(pixel, 0, bytes, pos2, pixelSize);
                ++x;
            }
            ++y;
        }
        bb.position(pos0);
        bb.put(bytes, 0, h * lineSize);
        bb.position(pos0);
        bb.limit(limit0);
    }

    private void rotateTextureByMinus90Degree(AbstractTextureImage ti) {
        int pixelSize = ti.getPixelSize();
        int w = ti.getWidth();
        int lineSize = w * pixelSize;
        int h = ti.getHeight();
        ByteBuffer bb = ti.getDataBuffer();
        int pos0 = bb.position();
        int limit0 = bb.limit();
        byte[] pixel = new byte[pixelSize];
        byte[] bytes = new byte[h * lineSize];
        int y = 0;
        while (y < h) {
            int posBase = y * lineSize;
            int x = 0;
            while (x < w) {
                int pos1 = posBase + x * pixelSize;
                int x2 = w - 1 - y;
                int y2 = x++;
                int pos2 = y2 * lineSize + x2 * pixelSize;
                bb.position(pos0 + pos1);
                bb.get(pixel, 0, pixelSize);
                System.arraycopy(pixel, 0, bytes, pos2, pixelSize);
            }
            ++y;
        }
        bb.position(pos0);
        bb.put(bytes, 0, h * lineSize);
        bb.position(pos0);
        bb.limit(limit0);
    }

    private AbstractTexture[] readSkyTextures(BSPEntitiesParser.BSPEntity[] entities, AbstractTexture sampleTexture, AppearanceFactory appFactory, URL baseURL) throws IOException {
        BSPEntitiesParser.BSPEntity_worldspawn entity_worlspawn = null;
        int i = 0;
        while (i < entities.length) {
            if (entities[i] instanceof BSPEntitiesParser.BSPEntity_worldspawn) {
                entity_worlspawn = (BSPEntitiesParser.BSPEntity_worldspawn)entities[i];
                break;
            }
            ++i;
        }
        String skyName = null;
        if (entity_worlspawn != null && (skyName = entity_worlspawn.skyName) == null) {
            skyName = entity_worlspawn.message;
        }
        if (skyName != null) {
            boolean FLIP_SKYBOX_TEXTURES = true;
            String[] skys = new String[]{"ft", "rt", "bk", "lf", "up", "dn"};
            AbstractTexture[] textures = new AbstractTexture[6];
            int sky_index = 0;
            while (sky_index < 6) {
                String skyFilename = "gfx/env/" + skyName + skys[sky_index];
                if (textures[sky_index] == null) {
                    textures[sky_index] = appFactory.loadOrGetTexture(String.valueOf(skyFilename) + ".tga", baseURL, true, false, false, true, false);
                    if (textures[sky_index] == null) {
                        textures[sky_index] = appFactory.loadOrGetTexture(String.valueOf(skyFilename) + ".jpg", baseURL, true, false, false, true, false);
                    }
                }
                if (textures[sky_index] == null) {
                    textures[sky_index] = sampleTexture;
                    System.err.println("missing sky-texture: " + skyFilename + " (.tga / .jpg)");
                } else {
                    this.flipTextureHorizontally(textures[sky_index].getImage(0));
                    if (sky_index >= 4) {
                        if (sky_index < 5) {
                            this.rotateTextureByMinus90Degree(textures[sky_index].getImage(0));
                        } else {
                            this.rotateTextureBy90Degree(textures[sky_index].getImage(0));
                        }
                    }
                }
                ++sky_index;
            }
            return textures;
        }
        AbstractTexture[] textures = new AbstractTexture[6];
        int sky_index = 0;
        while (sky_index < 6) {
            textures[sky_index] = sampleTexture;
            ++sky_index;
        }
        return textures;
    }

    private void readSpecialTexture(DataInputStream din, byte[][] palette, int orgWidth, int orgHeight, int width, int height, ByteBuffer bb, byte[] pixelData) throws IOException {
        boolean needsPostScaling = pixelData != null;
        boolean special_texture_transparency = false;
        int size = orgWidth * orgHeight;
        int pos = 0;
        int i = 0;
        while (i < size) {
            int palIdx = din.read();
            if (!needsPostScaling) {
                bb.put(palette[palIdx][0]);
                bb.put(palette[palIdx][1]);
                bb.put(palette[palIdx][2]);
                bb.put((byte)0);
            } else {
                pixelData[pos + 2] = palette[palIdx][0];
                pixelData[pos + 1] = palette[palIdx][1];
                pixelData[pos + 0] = palette[palIdx][2];
                pixelData[pos + 3] = 0;
                pos += 4;
            }
            ++i;
        }
        if (needsPostScaling) {
            WADFile.transferScaledBytes(pixelData, 4, bb, orgWidth, orgHeight, width, height);
        }
    }

    private void readRegularTexture(DataInputStream din, byte[][] palette, int orgWidth, int orgHeight, int width, int height, boolean changeGamma, ByteBuffer bb, byte[] pixelData) throws IOException {
        boolean needsPostScaling;
        boolean bl = needsPostScaling = pixelData != null;
        if (changeGamma) {
            float gamma = 1.0f;
            int i = 0;
            while (i < palette.length) {
                int j = 0;
                while (j < 3) {
                    float f = FastMath.pow((float)((float)((palette[i][j] & 0xFF) + 1) / 256.0f), (float)gamma);
                    float inf = f * 255.0f + 0.5f;
                    if (inf < 0.0f) {
                        inf = 0.0f;
                    }
                    if (inf > 255.0f) {
                        inf = 255.0f;
                    }
                    palette[i][j] = (byte)inf;
                    ++j;
                }
                ++i;
            }
        }
        int size = orgWidth * orgHeight;
        int pos = 0;
        int j = 0;
        while (j < size) {
            int palIdx = din.read();
            if (!needsPostScaling) {
                bb.put(palette[palIdx][0]);
                bb.put(palette[palIdx][1]);
                bb.put(palette[palIdx][2]);
            } else {
                pixelData[pos + 2] = palette[palIdx][0];
                pixelData[pos + 1] = palette[palIdx][1];
                pixelData[pos + 0] = palette[palIdx][2];
                pos += 3;
            }
            ++j;
        }
        if (needsPostScaling) {
            WADFile.transferScaledBytes(pixelData, 3, bb, orgWidth, orgHeight, width, height);
        }
    }

    private final AbstractTexture createNewTexture(AbstractTextureImage mipmap0, byte[] nameBytes, AppearanceFactory appFactory, boolean isSkyTexture) {
        AbstractTexture texture = appFactory.createTexture(mipmap0, !isSkyTexture);
        String name = new String(nameBytes).trim();
        texture.setName(name);
        try {
            String resName2 = String.valueOf(this.getWadType()) + "://" + this.getWADFilename() + "/" + name;
            Method m = texture.getClass().getMethod("setResourceName", String.class);
            m.invoke((Object)texture, resName2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return texture;
    }

    private final AbstractTexture[] readTexture(String resName, AppearanceFactory appFactory, URL baseURL, BSPEntitiesParser.BSPEntity[] entities, boolean ignoreAnimations) throws IOException {
        if (this.magicNumber == 1463895091) {
            int imgDataSize0;
            WADDirectoryEntry entry = this.wadDir.get(resName.toLowerCase());
            if (entry == null) {
                throw new IOException("The resource was not found in this WAD file.");
            }
            InputStream in = this.wadResource.openStream();
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            DataInputStream din = new DataInputStream(in);
            din.skip(entry.offset);
            byte[] nameBytes = new byte[16];
            din.read(nameBytes);
            int orgWidth = Integer.reverseBytes(din.readInt());
            int orgHeight = Integer.reverseBytes(din.readInt());
            int width = ImageUtility.roundUpPower2(orgWidth);
            int height = ImageUtility.roundUpPower2(orgHeight);
            int[] offsets = new int[4];
            int i = 0;
            while (i < 4) {
                offsets[i] = Integer.reverseBytes(din.readInt());
                ++i;
            }
            int imgDataSize = imgDataSize0 = offsets[1] - offsets[0];
            imgDataSize += (imgDataSize0 >>= 2);
            imgDataSize += (imgDataSize0 >>= 2);
            byte[] imgData = new byte[imgDataSize += (imgDataSize0 >>= 2)];
            din.read(imgData);
            int paletteSize = StreamUtils.readSwappedShort(din);
            byte[][] palette = new byte[paletteSize][];
            int i2 = 0;
            while (i2 < paletteSize) {
                palette[i2] = new byte[]{(byte)in.read(), (byte)in.read(), (byte)in.read()};
                ++i2;
            }
            din.close();
            boolean isAnimatedTexture = resName.startsWith("+");
            boolean isTransparentTexture = resName.startsWith("{");
            boolean isGlassTexture = resName.startsWith("glass");
            boolean isSkyTexture = resName.startsWith("sky");
            boolean isSpecialTexture = resName.startsWith("clip") || resName.startsWith("origin") || resName.startsWith("aatrigger");
            din = new DataInputStream(new ByteArrayInputStream(imgData));
            int numMipmaps = isSkyTexture ? 1 : 4;
            AbstractTextureImage[] mipmaps = new AbstractTextureImage[numMipmaps];
            int i3 = 0;
            while (i3 < numMipmaps) {
                mipmaps[i3] = isTransparentTexture || isGlassTexture || isSpecialTexture ? appFactory.createTextureImage(TextureImageFormat.RGBA, orgWidth, orgHeight, width, height) : appFactory.createTextureImage(TextureImageFormat.RGB, orgWidth, orgHeight, width, height);
                ByteBuffer bb = mipmaps[i3].getDataBuffer();
                byte[] pixelData = null;
                if (orgWidth != width || orgHeight != height) {
                    pixelData = new byte[orgWidth * orgHeight * mipmaps[i3].getPixelSize()];
                }
                if (isTransparentTexture) {
                    this.readTransparentTexture(din, palette, orgWidth, orgHeight, width, height, bb, pixelData);
                } else if (isGlassTexture) {
                    this.readGlassTexture(din, palette, orgWidth, orgHeight, width, height, bb, pixelData);
                } else if (isSkyTexture) {
                    this.readRegularTexture(din, palette, orgWidth, orgHeight, width, height, false, bb, pixelData);
                } else if (isSpecialTexture) {
                    this.readSpecialTexture(din, palette, orgWidth, orgHeight, width, height, bb, pixelData);
                } else {
                    this.readRegularTexture(din, palette, orgWidth, orgHeight, width, height, true, bb, pixelData);
                }
                bb.position(0);
                if (mipmaps[i3].getFormat().hasAlpha()) {
                    bb.limit(width * height * 4);
                } else {
                    bb.limit(width * height * 3);
                }
                orgWidth >>= 1;
                orgHeight >>= 1;
                width >>= 1;
                height >>= 1;
                ++i3;
            }
            din.close();
            AbstractTexture texture = this.createNewTexture(mipmaps[0], nameBytes, appFactory, isSkyTexture);
            if (isAnimatedTexture && !ignoreAnimations) {
                AbstractTexture[] animFrames = new AbstractTexture[10];
                AbstractTexture offFrame = null;
                int numFrames = 0;
                if (entry.fileName.charAt(1) == 'A' || entry.fileName.charAt(1) == 'a') {
                    offFrame = texture;
                } else {
                    animFrames[0] = texture;
                    numFrames = 1;
                }
                for (WADDirectoryEntry entry2 : this.wadDir.values()) {
                    if (!entry2.fileName.substring(2).equalsIgnoreCase(entry.fileName.substring(2)) || entry2.fileName.charAt(1) == entry.fileName.charAt(1)) continue;
                    if (entry2.fileName.charAt(1) == 'A' || entry2.fileName.charAt(1) == 'a') {
                        offFrame = this.readTexture(entry2.fileName, appFactory, baseURL, entities, true)[0];
                        continue;
                    }
                    animFrames[numFrames++] = this.readTexture(entry2.fileName, appFactory, baseURL, entities, true)[0];
                }
                AbstractTexture[] result = new AbstractTexture[numFrames + 1];
                System.arraycopy(animFrames, 0, result, 0, numFrames);
                result[result.length - 1] = offFrame;
                return result;
            }
            if (isSkyTexture) {
                AbstractTexture[] skyTextures = this.readSkyTextures(entities, texture, appFactory, baseURL);
                return new AbstractTexture[]{texture, skyTextures[0], skyTextures[1], skyTextures[2], skyTextures[3], skyTextures[4], skyTextures[5]};
            }
            return new AbstractTexture[]{texture};
        }
        return null;
    }

    public final AbstractTexture[] readTexture(String resName, AppearanceFactory appFactory) throws IOException {
        return this.readTexture(resName, appFactory, null, null, false);
    }

    public final AbstractTexture[] readSkyTextures(String resName, AppearanceFactory appFactory, URL baseURL, BSPEntitiesParser.BSPEntity[] entities) throws IOException {
        return this.readTexture(resName, appFactory, baseURL, entities, false);
    }

    private HashMap<String, WADDirectoryEntry> readWADDirectory(URL wadFile) throws IOException, IncorrectFormatException, ParsingException {
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(wadFile.openStream()));
            int magicNumber = in.readInt();
            if (magicNumber != 1463895091) {
                throw new IncorrectFormatException("This is not a WAD3 file!");
            }
            this.magicNumber = magicNumber;
            this.wadType = "WAD3";
            int lumpCount = Integer.reverseBytes(in.readInt());
            int dirOffset = Integer.reverseBytes(in.readInt());
            HashMap<String, WADDirectoryEntry> wadDir = new HashMap<String, WADDirectoryEntry>(lumpCount);
            in.skipBytes(dirOffset - 12);
            byte[] bytes16 = new byte[16];
            int i = 0;
            while (i < lumpCount) {
                WADDirectoryEntry entry = new WADDirectoryEntry();
                entry.offset = Integer.reverseBytes(in.readInt());
                entry.compFileSize = Integer.reverseBytes(in.readInt());
                entry.uncompFileSize = Integer.reverseBytes(in.readInt());
                entry.fileType = in.readByte();
                entry.compType = in.readByte();
                entry.padding = new byte[]{in.readByte(), in.readByte()};
                in.read(bytes16, 0, 16);
                entry.fileName = new String(bytes16).trim();
                wadDir.put(entry.fileName.toLowerCase(), entry);
                ++i;
            }
            in.close();
            return wadDir;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            throw new ParsingException(t);
        }
    }

    private static final String getWADFileSimpleName(URL wadResource) {
        String filePath = wadResource.getFile();
        int lastSlashPos = filePath.lastIndexOf(47);
        if (lastSlashPos == -1) {
            return filePath;
        }
        return filePath.substring(lastSlashPos + 1);
    }

    public WADFile(URL wadResource) throws IOException, IncorrectFormatException, ParsingException {
        this.wadResource = wadResource;
        this.wadFilename = WADFile.getWADFileSimpleName(wadResource);
        this.wadDir = this.readWADDirectory(wadResource);
    }

    private static class WADDirectoryEntry {
        public long offset = 0L;
        public int compFileSize = 0;
        public int uncompFileSize = 0;
        public byte fileType = 0;
        public byte compType = 0;
        public byte[] padding = null;
        public String fileName = null;

        private WADDirectoryEntry() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " { " + "name: \"" + this.fileName + "\"" + "\t | offset: " + this.offset + "\t | compFileSize: " + this.compFileSize + "\t | uncompFileSize: " + this.uncompFileSize + "\t | fileType: " + this.fileType + "\t | compType: " + this.compType + "\t | pad1: " + this.padding[0] + "\t | pad2: " + this.padding[1] + " }";
        }
    }
}

