/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp.lumps;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class BSPVertex {
    public Point3f position = new Point3f();
    public TexCoord2f texCoord = new TexCoord2f();
    public TexCoord2f lightTexCoord = new TexCoord2f();
    public Vector3f normal = new Vector3f();
    public Colorf color = new Colorf();

    public void swizzle() {
        float y = this.position.getY();
        this.position.setY(this.position.getZ());
        this.position.setZ(-y);
    }

    public void scale(float scale) {
        this.position.scale(scale);
        this.texCoord.mul(scale);
        this.lightTexCoord.mul(scale);
        this.normal.scale(scale);
        this.color.mul(scale);
    }

    public void add(BSPVertex v) {
        this.position.add((TupleNf)v.position);
        this.texCoord.add((TexCoordf)v.texCoord);
        this.lightTexCoord.add((TexCoordf)v.lightTexCoord);
        this.color.add(v.color);
    }

    public void set(BSPVertex a) {
        this.position.set((TupleNf)a.position);
        this.texCoord.set((TexCoordf)a.texCoord);
        this.lightTexCoord.set((TexCoordf)a.lightTexCoord);
        this.color.set(a.color);
    }

    public void avg(BSPVertex a, BSPVertex b) {
        this.set(a);
        this.add(b);
        this.scale(0.5f);
    }

    public BSPVertex copy() {
        BSPVertex v = new BSPVertex();
        v.position.set((TupleNf)this.position);
        v.texCoord.set((TexCoordf)this.texCoord);
        v.lightTexCoord.set((TexCoordf)this.lightTexCoord);
        v.normal.set((TupleNf)this.normal);
        v.color.set(this.color);
        return v;
    }
}

