/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d;

import java.util.Iterator;
import org.jagatoo.loaders.models.cal3d.core.CalAnimationCycle;
import org.jagatoo.loaders.models.cal3d.core.CalModel;

public class Cal3dController {
    private final CalModel calModel;
    private String activeAnimation;
    private float activeDuration = 0.0f;
    private float lastTime = 0.0f;

    public Cal3dController(CalModel calModel) {
        this.calModel = calModel;
    }

    private CalModel getInternalModel() {
        return this.calModel;
    }

    public void blendAnim(String anim, float weight, float delay) {
        if (this.animationExists(anim)) {
            this.getInternalModel().getMixer().blendCycle(anim, weight, delay);
        }
    }

    public void clearAnim(String anim) {
        this.getInternalModel().getMixer().clearCycle(anim, 0.0f);
    }

    public void setAnimation(String anim, float delay, float duration) {
        if (this.animationExists(anim)) {
            this.getInternalModel().getMixer().executeAction(anim, 0.0f, 0.0f);
        }
    }

    public void setAnimation(String anim) {
        if (this.animationExists(anim)) {
            this.clearAnimations();
            this.activeAnimation = anim;
            CalAnimationCycle cycle = this.getInternalModel().getMixer().blendCycle(anim, 1.0f, 0.0f);
            cycle.setAsync(0.0f, 0.0f);
        }
    }

    public void clearAnimations() {
        this.activeAnimation = null;
        Iterator<String> it = this.getInternalModel().getMixer().mapAnimation.keySet().iterator();
        while (it.hasNext()) {
            this.getInternalModel().getMixer().clearCycle(it.next(), 0.0f);
        }
    }

    private boolean animationExists(String anim) {
        return this.getInternalModel().getCoreModel().getCoreAnimation(anim) != null;
    }
}

