/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.openmali.vecmath2.Vector2f;

public class Vector2fBuffer {
    FloatBuffer floatBuffer;

    public Vector2fBuffer(int length) {
        this.floatBuffer = ByteBuffer.allocateDirect(length * 4 * 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public void put(int n, float x, float y) {
        this.floatBuffer.put(2 * n + 0, x);
        this.floatBuffer.put(2 * n + 1, y);
    }

    public void put(int n, Vector2f v) {
        this.floatBuffer.put(2 * n + 0, v.getX());
        this.floatBuffer.put(2 * n + 1, v.getY());
    }

    public void putX(int n, float x) {
        this.floatBuffer.put(2 * n + 0, x);
    }

    public void putY(int n, float y) {
        this.floatBuffer.put(2 * n + 1, y);
    }

    public Vector2f get(int n) {
        return new Vector2f(this.floatBuffer.get(2 * n + 0), this.floatBuffer.get(2 * n + 1));
    }

    public float getX(int n) {
        return this.floatBuffer.get(2 * n + 0);
    }

    public float getY(int n) {
        return this.floatBuffer.get(2 * n + 1);
    }

    public FloatBuffer getBuffer() {
        return this.floatBuffer;
    }
}

