/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import org.jagatoo.loaders.models.cal3d.core.CalAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;

public class CalAnimationAction
extends CalAnimation {
    protected float delayIn;
    protected float delayOut;
    protected float delayTarget;
    protected float weightTarget;
    protected boolean autoLock;

    public CalAnimationAction(CalCoreAnimation coreAnimation) {
        this.type = 3;
        if (coreAnimation == null) {
            throw new IllegalArgumentException();
        }
        this.coreAnimation = coreAnimation;
    }

    public void execute(float delayIn, float delayOut) {
        this.execute(delayIn, delayOut, 1.0f, false);
    }

    public void execute(float delayIn, float delayOut, float weightTarget, boolean autoLock) {
        this.state = 3;
        this.weight = 0.0f;
        this.time = 0.0f;
        this.delayIn = delayIn;
        this.delayOut = delayOut;
        this.weightTarget = weightTarget;
        this.autoLock = autoLock;
    }

    public boolean update(float deltaTime) {
        if (this.state != 5) {
            this.time += deltaTime * this.timeFactor;
        }
        if (this.state == 3) {
            if (this.time < this.delayIn) {
                this.weight = this.time / this.delayIn * this.weightTarget;
            } else {
                this.state = 4;
                this.weight = this.weightTarget;
            }
        }
        if (this.state == 4) {
            if (!this.autoLock && this.time >= this.coreAnimation.getDuration() - this.delayOut) {
                this.state = 5;
            } else if (this.autoLock && this.time >= this.coreAnimation.getDuration()) {
                this.state = 5;
                this.time = this.coreAnimation.getDuration();
            }
        }
        if (this.state == 5) {
            if (this.time < this.coreAnimation.getDuration()) {
                this.weight = (this.coreAnimation.getDuration() - this.time) / this.delayOut * this.weightTarget;
            } else {
                this.weight = 0.0f;
                return false;
            }
        }
        return true;
    }
}

