/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import org.jagatoo.loaders.models.cal3d.core.CalAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;

public class CalAnimationCycle
extends CalAnimation {
    protected float targetDelay;
    protected float targetWeight;

    public CalAnimationCycle(CalCoreAnimation coreAnimation) {
        if (coreAnimation == null) {
            throw new IllegalArgumentException();
        }
        this.coreAnimation = coreAnimation;
        this.type = 1;
        this.state = 1;
        this.weight = 0.0f;
        this.targetDelay = 0.0f;
        this.targetWeight = 0.0f;
    }

    public void blend(float weight, float delay) {
        this.targetWeight = weight;
        this.targetDelay = delay;
    }

    public void setAsync(float time, float duration) {
        if (this.state != 2) {
            if (duration == 0.0f) {
                this.timeFactor = 1.0f;
                time = 0.0f;
            } else {
                this.timeFactor = this.coreAnimation.getDuration() / duration;
                time *= this.timeFactor;
            }
            this.state = 2;
        }
    }

    public void setAsync() {
        this.setAsync(0.0f, this.coreAnimation.getDuration());
    }

    public boolean update(float deltaTime) {
        if (this.state == 0) {
            return true;
        }
        if (this.targetDelay <= deltaTime) {
            this.weight = this.targetWeight;
            this.targetDelay = 0.0f;
            if (this.weight == 0.0f) {
                return false;
            }
        } else {
            float factor = deltaTime / this.targetDelay;
            this.weight = (1.0f - factor) * this.weight + factor * this.targetWeight;
            this.targetDelay -= deltaTime;
        }
        if (this.state == 2) {
            this.time += deltaTime * this.timeFactor;
            if (this.time >= this.coreAnimation.getDuration()) {
                this.time %= this.coreAnimation.getDuration();
            }
            if (this.time < 0.0f) {
                this.time += this.coreAnimation.getDuration();
            }
        }
        return true;
    }
}

