/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.ArrayList;
import org.jagatoo.loaders.models.cal3d.core.CalCoreBone;
import org.jagatoo.loaders.models.cal3d.core.CalSkeleton;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class CalBone {
    protected CalCoreBone coreBone;
    protected CalSkeleton skeleton;
    protected float accumulatedWeight;
    protected float accumulatedWeightAbsolute;
    protected Vector3f translation = new Vector3f();
    protected Quaternion4f rotation = new Quaternion4f();
    protected Vector3f translationAbsolute = new Vector3f();
    protected Quaternion4f rotationAbsolute = new Quaternion4f();
    protected Vector3f translationBoneSpace = new Vector3f();
    protected Quaternion4f rotationBoneSpace = new Quaternion4f();
    protected Matrix3f transformMatrix = new Matrix3f();
    protected Matrix3f tmpMatrix = new Matrix3f();

    public CalBone(CalCoreBone coreBone) {
        if (coreBone == null) {
            throw new IllegalArgumentException();
        }
        this.coreBone = coreBone;
        this.clearState();
    }

    public void setCoreState() {
        this.translation = this.coreBone.getTranslation();
        this.rotation = this.coreBone.getRotation();
        this.accumulatedWeightAbsolute = 1.0f;
        this.accumulatedWeight = 1.0f;
        this.calculateState();
    }

    public void setCoreStateRecursive() {
        this.translation = this.coreBone.getTranslation();
        this.rotation = this.coreBone.getRotation();
        this.accumulatedWeightAbsolute = 1.0f;
        this.accumulatedWeight = 1.0f;
        for (int childId : this.coreBone.listChildId) {
            this.skeleton.getBone(childId).setCoreStateRecursive();
        }
        this.calculateState();
    }

    public void blendState(float weight, Vector3f translation, Quaternion4f rotation) {
        if (this.accumulatedWeightAbsolute == 0.0f) {
            this.translationAbsolute.set((TupleNf)translation);
            this.rotationAbsolute.set((TupleNf)rotation);
            this.accumulatedWeightAbsolute = weight;
        } else {
            float factor = weight / (this.accumulatedWeightAbsolute + weight);
            this.translationAbsolute.interpolate((TupleNf)translation, factor);
            this.rotationAbsolute.interpolate(rotation, factor);
            this.accumulatedWeightAbsolute += weight;
        }
    }

    public void applyState(float weight, Vector3f translation, Quaternion4f rotation) {
        this.translation.add((TupleNf)translation);
        this.rotation.mul(rotation, this.rotation);
    }

    public void lockState() {
        if (this.accumulatedWeightAbsolute > 1.0f - this.accumulatedWeight) {
            this.accumulatedWeightAbsolute = 1.0f - this.accumulatedWeight;
        }
        if (this.accumulatedWeightAbsolute > 0.0f) {
            if (this.accumulatedWeight == 0.0f) {
                this.translation.set((TupleNf)this.translationAbsolute);
                this.rotation.set((TupleNf)this.rotationAbsolute);
                this.accumulatedWeight = this.accumulatedWeightAbsolute;
            } else {
                float factor = this.accumulatedWeightAbsolute / (this.accumulatedWeight + this.accumulatedWeightAbsolute);
                this.translation.interpolate((TupleNf)this.translationAbsolute, factor);
                this.rotation.interpolate(this.rotationAbsolute, factor);
                this.accumulatedWeight += this.accumulatedWeightAbsolute;
            }
            this.accumulatedWeightAbsolute = 0.0f;
        }
    }

    public void calculateState() {
        int parentId;
        if (this.accumulatedWeight == 0.0f) {
            this.translation.set((TupleNf)this.coreBone.getTranslation());
            this.rotation.set((TupleNf)this.coreBone.getRotation());
        }
        if ((parentId = this.coreBone.getParentId()) == -1) {
            this.translationAbsolute.set((TupleNf)this.translation);
            this.rotationAbsolute.set((TupleNf)this.rotation);
        } else {
            CalBone parent = this.skeleton.getBone(parentId);
            this.translationAbsolute.set((TupleNf)this.translation);
            CalCoreBone.transform(this.translationAbsolute, parent.getRotationAbsolute());
            this.translationAbsolute.add((TupleNf)parent.getTranslationAbsolute());
            this.rotationAbsolute.set((TupleNf)this.rotation);
            this.rotationAbsolute.mul(parent.getRotationAbsolute());
        }
        this.translationBoneSpace.set((TupleNf)this.coreBone.getTranslationBoneSpace());
        CalCoreBone.transform(this.translationBoneSpace, this.rotationAbsolute);
        this.translationBoneSpace.add((TupleNf)this.translationAbsolute);
        this.rotationBoneSpace.set((TupleNf)this.coreBone.getRotationBoneSpace());
        this.rotationBoneSpace.mul(this.rotationAbsolute);
        this.transformMatrix.set(this.rotationBoneSpace);
        ArrayList<Integer> list = this.coreBone.getListChildId();
        int i = 0;
        while (i < list.size()) {
            int childId = list.get(i);
            this.skeleton.getBone(childId).calculateState();
            ++i;
        }
    }

    public void clearState() {
        this.accumulatedWeight = 0.0f;
        this.accumulatedWeightAbsolute = 0.0f;
    }

    public CalCoreBone getCoreBone() {
        return this.coreBone;
    }

    public Quaternion4f getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternion4f rotation) {
        this.rotation.set((TupleNf)rotation);
        this.accumulatedWeightAbsolute = 1.0f;
        this.accumulatedWeight = 1.0f;
    }

    public Quaternion4f getRotationAbsolute() {
        return this.rotationAbsolute;
    }

    public Quaternion4f getRotationBoneSpace() {
        return this.rotationBoneSpace;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vector3f translation) {
        this.translation.set((TupleNf)translation);
        this.accumulatedWeightAbsolute = 1.0f;
        this.accumulatedWeight = 1.0f;
    }

    public Vector3f getTranslationAbsolute() {
        return this.translationAbsolute;
    }

    public Vector3f getTranslationBoneSpace() {
        return this.translationBoneSpace;
    }

    public Matrix3f getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setSkeleton(CalSkeleton skeleton) {
        this.skeleton = skeleton;
    }

    public String toString() {
        return this.coreBone.name;
    }
}

