/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jagatoo.loaders.models.cal3d.core.CalAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalAnimationAction;
import org.jagatoo.loaders.models.cal3d.core.CalAnimationCycle;
import org.jagatoo.loaders.models.cal3d.core.CalAnimationRelative;
import org.jagatoo.loaders.models.cal3d.core.CalBone;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreTrack;
import org.jagatoo.loaders.models.cal3d.core.CalModel;
import org.jagatoo.loaders.models.cal3d.core.CalSkeleton;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class CalMixer {
    public CalModel model;
    public Map<String, CalAnimation> mapAnimation = new HashMap<String, CalAnimation>();
    public List<CalAnimationAction> listAnimationAction = new ArrayList<CalAnimationAction>();
    public List<CalAnimationCycle> listAnimationCycle = new ArrayList<CalAnimationCycle>();
    public List<CalAnimationRelative> additiveAnimationCycles = new ArrayList<CalAnimationRelative>();
    protected float animationTime = 0.0f;
    protected float animationDuration = 0.0f;
    public float timeFactor = 1.0f;

    public CalMixer(CalModel model) {
        this.model = model;
    }

    public synchronized CalAnimationCycle blendCycle(String id, float weight, float delay) {
        CalAnimation animation = this.mapAnimation.get(id);
        if (animation == null) {
            if (weight == 0.0f) {
                return null;
            }
            CalCoreAnimation coreAnimation = this.model.getCoreModel().getCoreAnimation(id);
            if (coreAnimation == null) {
                throw new IllegalArgumentException("Animation does not exist: " + id);
            }
            CalAnimationCycle animationCycle = new CalAnimationCycle(coreAnimation);
            this.mapAnimation.put(id, animationCycle);
            this.listAnimationCycle.add(0, animationCycle);
            animationCycle.blend(weight, delay);
            return animationCycle;
        }
        if (animation.getType() != 1) {
            throw new IllegalArgumentException("Animation \"" + id + "\" is not a cycle");
        }
        if (weight == 0.0f) {
            this.mapAnimation.remove(id);
        }
        CalAnimationCycle animationCycle = (CalAnimationCycle)animation;
        animationCycle.blend(weight, delay);
        return animationCycle;
    }

    public final CalAnimation scrubToPosition(String id, float position) {
        return this.scrubToPosition(id, position, 1.0f);
    }

    public synchronized CalAnimation scrubToPosition(String id, float position, float weight) {
        CalAnimation animation = this.mapAnimation.get(id);
        if (animation == null) {
            CalCoreAnimation coreAnimation = this.model.getCoreModel().getCoreAnimation(id);
            if (coreAnimation == null) {
                throw new IllegalArgumentException("Animation does not exist: " + id);
            }
            CalAnimationCycle animationCycle = new CalAnimationCycle(coreAnimation);
            this.mapAnimation.put(id, animationCycle);
            this.listAnimationCycle.add(0, animationCycle);
            animation = animationCycle;
        }
        CalCoreAnimation coreAnim = animation.getCoreAnimation();
        float time = position * coreAnim.getDuration();
        animation.freeze(time, weight);
        return animation;
    }

    public final CalAnimation scrubToTime(String id, float time) {
        return this.scrubToTime(id, time, 1.0f);
    }

    public synchronized CalAnimation scrubToTime(String id, float time, float weight) {
        CalCoreAnimation coreAnim;
        CalAnimation animation = this.mapAnimation.get(id);
        if (animation == null) {
            CalCoreAnimation coreAnimation = this.model.getCoreModel().getCoreAnimation(id);
            if (coreAnimation == null) {
                throw new IllegalArgumentException("Animation does not exist: " + id);
            }
            CalAnimationCycle animationCycle = new CalAnimationCycle(coreAnimation);
            this.mapAnimation.put(id, animationCycle);
            this.listAnimationCycle.add(0, animationCycle);
            animation = animationCycle;
        }
        if ((time %= (coreAnim = animation.getCoreAnimation()).getDuration()) < 0.0f) {
            time += coreAnim.getDuration();
        }
        animation.freeze(time, weight);
        return animation;
    }

    public synchronized CalAnimation applyAdditiveCycle(String id, float time) {
        CalAnimation animation = this.mapAnimation.get(id);
        if (animation == null) {
            CalCoreAnimation coreAnimation = this.model.getCoreModel().getCoreAnimation(id);
            if (coreAnimation == null) {
                throw new IllegalArgumentException("Animation does not exist: " + id);
            }
            CalAnimationRelative animationCycle = new CalAnimationRelative(coreAnimation);
            this.mapAnimation.put(id, animationCycle);
            this.additiveAnimationCycles.add(0, animationCycle);
            animation = animationCycle;
        }
        CalCoreAnimation coreAnim = animation.getCoreAnimation();
        animation.freeze(time %= coreAnim.getDuration(), 1.0f);
        return animation;
    }

    public synchronized CalAnimation applyAdditiveCycle(String id, String baseId, float time) {
        CalAnimation animation = this.mapAnimation.get(id);
        if (animation == null) {
            CalCoreAnimation coreAnimation = this.model.getCoreModel().getCoreAnimation(id);
            CalCoreAnimation basePose = this.model.getCoreModel().getCoreAnimation(baseId);
            if (coreAnimation == null) {
                throw new IllegalArgumentException("Animation does not exist: " + id);
            }
            if (basePose == null) {
                throw new IllegalArgumentException("Animation does not exist: " + baseId);
            }
            CalAnimationRelative animationCycle = new CalAnimationRelative(coreAnimation, basePose);
            this.mapAnimation.put(id, animationCycle);
            this.additiveAnimationCycles.add(0, animationCycle);
            animation = animationCycle;
        }
        CalCoreAnimation coreAnim = animation.getCoreAnimation();
        animation.freeze(time %= coreAnim.getDuration(), 1.0f);
        return animation;
    }

    public synchronized void clearCycle(String id, float delay) {
        CalAnimation animation = this.mapAnimation.get(id);
        if (animation == null) {
            return;
        }
        if (animation.getType() != 1) {
            throw new IllegalArgumentException("Animation \"" + id + "\" is not a cycle");
        }
        this.mapAnimation.remove(id);
        CalAnimationCycle animationCycle = (CalAnimationCycle)animation;
        animationCycle.setAsync(this.animationTime, this.animationDuration);
        animationCycle.blend(0.0f, delay);
    }

    public synchronized void clearAdditiveCycle(String id) {
        CalAnimation animation = this.mapAnimation.get(id);
        if (animation == null) {
            return;
        }
        this.mapAnimation.remove(id);
        this.additiveAnimationCycles.remove(animation);
    }

    public synchronized void clearAllAnims() {
        this.mapAnimation.clear();
        this.listAnimationAction.clear();
        this.listAnimationCycle.clear();
        this.additiveAnimationCycles.clear();
    }

    public synchronized CalAnimationAction executeAction(String id, float delayIn, float delayOut) {
        return this.executeAction(id, delayIn, delayOut, 1.0f, false);
    }

    public synchronized CalAnimationAction executeAction(String id, float delayIn, float delayOut, float weightTarget, boolean autoLock) {
        CalCoreAnimation coreAnimation = this.model.getCoreModel().getCoreAnimation(id);
        CalAnimationAction animationAction = new CalAnimationAction(coreAnimation);
        this.listAnimationAction.add(0, animationAction);
        animationAction.execute(delayIn, delayOut, weightTarget, autoLock);
        return animationAction;
    }

    public void clearAction(String id) {
        CalCoreAnimation coreAnimation = this.model.getCoreModel().getCoreAnimation(id);
        Iterator<CalAnimationAction> i = this.listAnimationAction.iterator();
        while (i.hasNext()) {
            if (i.next().getCoreAnimation() != coreAnimation) continue;
            i.remove();
        }
    }

    public synchronized void updateAnimation(float deltaTime) {
        if (this.animationDuration == 0.0f) {
            this.animationTime = 0.0f;
        } else {
            this.animationTime += deltaTime * this.timeFactor;
            if (this.animationTime >= this.animationDuration) {
                this.animationTime %= this.animationDuration;
            }
            if (this.animationTime < 0.0f) {
                this.animationTime += this.animationDuration;
            }
        }
        Iterator<CalAnimationAction> iteratorAnimationAction = this.listAnimationAction.iterator();
        while (iteratorAnimationAction.hasNext()) {
            CalAnimationAction animationAction = iteratorAnimationAction.next();
            if (animationAction.update(deltaTime)) continue;
            iteratorAnimationAction.remove();
        }
        float accumulatedWeight = 0.0f;
        float accumulatedDuration = 0.0f;
        Iterator<CalAnimationCycle> iteratorAnimationCycle = this.listAnimationCycle.iterator();
        while (iteratorAnimationCycle.hasNext()) {
            CalAnimationCycle animationCycle = iteratorAnimationCycle.next();
            if (animationCycle.update(deltaTime)) {
                if (animationCycle.getState() != 1) continue;
                accumulatedWeight += animationCycle.getWeight();
                accumulatedDuration += animationCycle.getWeight() * animationCycle.getCoreAnimation().getDuration();
                continue;
            }
            iteratorAnimationCycle.remove();
        }
        this.animationDuration = accumulatedWeight > 0.0f ? accumulatedDuration / accumulatedWeight : 0.0f;
    }

    public synchronized void updateSkeleton() {
        CalCoreAnimation coreAnimation;
        CalSkeleton skeleton = this.model.getSkeleton();
        skeleton.clearState();
        CalBone[] vectorBone = skeleton.getBones();
        Vector3f translation = new Vector3f();
        Quaternion4f rotation = new Quaternion4f();
        for (CalAnimationAction animationAction : this.listAnimationAction) {
            coreAnimation = animationAction.getCoreAnimation();
            for (CalCoreTrack coreTrack : coreAnimation.getListCoreTrack()) {
                CalBone bone = vectorBone[coreTrack.getCoreBoneId()];
                coreTrack.getState(animationAction.getTime(), translation, rotation);
                bone.blendState(animationAction.getWeight(), translation, rotation);
            }
        }
        skeleton.lockState();
        for (CalAnimationCycle animationCycle : this.listAnimationCycle) {
            coreAnimation = animationCycle.getCoreAnimation();
            float animationTime = 0.0f;
            animationTime = animationCycle.getState() == 1 ? (this.animationDuration > 0.0f ? this.animationTime * coreAnimation.getDuration() / this.animationDuration : 0.0f) : animationCycle.getTime();
            for (CalCoreTrack coreTrack : coreAnimation.getListCoreTrack()) {
                CalBone bone = vectorBone[coreTrack.getCoreBoneId()];
                coreTrack.getState(animationTime, translation, rotation);
                if (coreTrack.getCoreBoneId() == 0) {
                    if (animationCycle.rootDisplacement != null) {
                        translation.sub((TupleNf)animationCycle.rootDisplacement);
                    }
                    if (animationCycle.rootRotation != null) {
                        rotation.mulInverse(animationCycle.rootRotation);
                    }
                }
                bone.blendState(animationCycle.getWeight(), translation, rotation);
            }
        }
        skeleton.lockState();
        for (CalAnimationRelative animation : this.additiveAnimationCycles) {
            for (CalCoreTrack coreTrack : animation.getCoreAnimation().getListCoreTrack()) {
                CalBone bone = vectorBone[coreTrack.getCoreBoneId()];
                Vector3f translation0 = new Vector3f();
                Quaternion4f rotation0 = new Quaternion4f();
                animation.getBaseState(coreTrack, translation0, rotation0);
                coreTrack.getState(animation.getTime(), translation, rotation);
                translation.set(0.0f, 0.0f, 0.0f);
                rotation.mulInverse(rotation0);
                bone.applyState(animation.getWeight(), translation, rotation);
            }
        }
        skeleton.calculateState();
    }
}

