/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import org.jagatoo.loaders.models.cal3d.core.CalModel;

public class CalMorphTargetMixer {
    private CalModel model;
    private float[] vectorCurrentWeight;
    private float[] vectorEndWeight;
    private float[] vectorDuration;

    public CalMorphTargetMixer(CalModel model) {
        int morphAnimationCount = model.getCoreModel().getCoreMorphAnimationCount();
        if (morphAnimationCount > 0) {
            this.vectorCurrentWeight = new float[morphAnimationCount];
            this.vectorEndWeight = new float[morphAnimationCount];
            this.vectorDuration = new float[morphAnimationCount];
        }
    }

    public void blend(int id, float weight, float delay) {
        this.vectorEndWeight[id] = weight;
        this.vectorDuration[id] = delay;
    }

    public void clear(int id, float delay) {
        this.vectorEndWeight[id] = 0.0f;
        this.vectorDuration[id] = delay;
    }

    public float getCurrentWeight(int id) {
        return this.vectorCurrentWeight[id];
    }

    public float getCurrentWeightBase() {
        float currentWeight = 1.0f;
        float[] fArray = this.vectorCurrentWeight;
        int n = this.vectorCurrentWeight.length;
        int n2 = 0;
        while (n2 < n) {
            float weight = fArray[n2];
            currentWeight -= weight;
            ++n2;
        }
        return currentWeight;
    }

    public int getMorphTargetCount() {
        return this.vectorCurrentWeight.length;
    }

    public void update(float deltaTime) {
        int n = 0;
        while (n < this.vectorCurrentWeight.length) {
            if (deltaTime >= this.vectorDuration[n]) {
                this.vectorCurrentWeight[n] = this.vectorEndWeight[n];
                this.vectorDuration[n] = 0.0f;
            } else {
                int n2 = n;
                this.vectorCurrentWeight[n2] = this.vectorCurrentWeight[n2] + (this.vectorEndWeight[n] - this.vectorCurrentWeight[n]) * deltaTime / this.vectorDuration[n];
                int n3 = n;
                this.vectorDuration[n3] = this.vectorDuration[n3] - deltaTime;
            }
            ++n;
        }
    }
}

