/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openmali.vecmath2.Colorf;

public class CalPlatform {
    public static String readString(DataInput file) throws IOException {
        int length = file.readInt();
        if (length < 0) {
            return null;
        }
        byte[] strBuffer = new byte[length];
        file.readFully(strBuffer);
        return new String(strBuffer, 0, length - 1);
    }

    public static Colorf readColour(DataInput file) throws IOException {
        float r = (float)file.readUnsignedByte() / 256.0f;
        float g = (float)file.readUnsignedByte() / 256.0f;
        float b = (float)file.readUnsignedByte() / 256.0f;
        float a = (float)file.readUnsignedByte() / 256.0f;
        return new Colorf(r, g, b, a);
    }

    public static void writeColour(DataOutput file, Colorf colorf) throws IOException {
        Color colorb = colorf.getAWTColor();
        file.writeByte(colorb.getRed());
        file.writeByte(colorb.getGreen());
        file.writeByte(colorb.getBlue());
        file.writeByte(colorb.getAlpha());
    }

    public static void writeString(DataOutput file, String strValue) throws IOException {
        int length = strValue.length() + 1;
        file.writeInt(length);
        file.writeBytes(strValue);
        file.writeByte(0);
    }
}

