/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.buffer.TexCoord2fBuffer;
import org.jagatoo.loaders.models.cal3d.buffer.Vector3fBuffer;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreBone;
import org.jagatoo.loaders.models.cal3d.core.CalCoreKeyframe;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMesh;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSkeleton;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.jagatoo.loaders.models.cal3d.core.CalCoreTrack;
import org.jagatoo.loaders.models.cal3d.core.CalLoader;
import org.jagatoo.loaders.models.cal3d.core.CalPlatform;
import org.jagatoo.util.streams.LittleEndianDataOutputStream;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector3f;

public class CalSaver {
    public static void saveCoreAnimation(OutputStream file, CalCoreAnimation coreAnimation) throws IOException {
        LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(file);
        out.write(CalLoader.ANIMATION_FILE_MAGIC);
        out.writeInt(1000);
        out.writeFloat(coreAnimation.getDuration());
        List<CalCoreTrack> listCoreTrack = coreAnimation.getListCoreTrack();
        out.writeInt(listCoreTrack.size());
        for (CalCoreTrack track : listCoreTrack) {
            CalSaver.saveCoreTrack(out, track);
        }
    }

    protected static void saveCoreBones(DataOutput file, CalCoreBone coreBone) throws IOException {
        CalPlatform.writeString(file, coreBone.getName());
        Vector3f translation = coreBone.getTranslation();
        file.writeFloat(translation.getX());
        file.writeFloat(translation.getY());
        file.writeFloat(translation.getZ());
        Quaternion4f rotation = coreBone.getRotation();
        file.writeFloat(rotation.getA());
        file.writeFloat(rotation.getB());
        file.writeFloat(rotation.getC());
        file.writeFloat(rotation.getD());
        Vector3f translationBoneSpace = coreBone.getTranslationBoneSpace();
        file.writeFloat(translationBoneSpace.getX());
        file.writeFloat(translationBoneSpace.getY());
        file.writeFloat(translationBoneSpace.getZ());
        Quaternion4f rotationBoneSpace = coreBone.getRotationBoneSpace();
        file.writeFloat(rotationBoneSpace.getA());
        file.writeFloat(rotationBoneSpace.getB());
        file.writeFloat(rotationBoneSpace.getC());
        file.writeFloat(rotationBoneSpace.getD());
        file.writeInt(coreBone.getParentId());
        ArrayList<Integer> listChildId = coreBone.getListChildId();
        file.writeInt(listChildId.size());
        Iterator iterator = listChildId.iterator();
        while (iterator.hasNext()) {
            int childId = (Integer)iterator.next();
            file.writeInt(childId);
        }
    }

    protected static void saveCoreKeyframe(DataOutput file, CalCoreKeyframe coreKeyframe) throws IOException {
        file.writeFloat(coreKeyframe.getTime());
        Vector3f translation = coreKeyframe.getTranslation();
        file.writeFloat(translation.getX());
        file.writeFloat(translation.getY());
        file.writeFloat(translation.getZ());
        Quaternion4f rotation = coreKeyframe.getRotation();
        file.writeFloat(rotation.getA());
        file.writeFloat(rotation.getB());
        file.writeFloat(rotation.getC());
        file.writeFloat(rotation.getD());
    }

    public static void saveCoreMaterial(OutputStream file, CalCoreMaterial coreMaterial) throws IOException {
        LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(file);
        out.write(CalLoader.MATERIAL_FILE_MAGIC);
        out.writeInt(1000);
        CalPlatform.writeColour(out, coreMaterial.getAmbientColor());
        CalPlatform.writeColour(out, coreMaterial.getDiffuseColor());
        CalPlatform.writeColour(out, coreMaterial.getSpecularColor());
        out.writeFloat(coreMaterial.getShininess());
        CalCoreMaterial.Map[] vectorMap = coreMaterial.getMaps();
        out.writeInt(vectorMap.length);
        CalCoreMaterial.Map[] mapArray = vectorMap;
        int n = vectorMap.length;
        int n2 = 0;
        while (n2 < n) {
            CalCoreMaterial.Map map = mapArray[n2];
            CalPlatform.writeString(out, map.filename);
            ++n2;
        }
    }

    public static void saveCoreMesh(OutputStream file, CalCoreMesh coreMesh) throws IOException {
        LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(file);
        out.write(CalLoader.MESH_FILE_MAGIC);
        out.writeInt(1000);
        Vector<CalCoreSubmesh> vectorCoreSubmesh = coreMesh.getVectorCoreSubmesh();
        out.writeInt(vectorCoreSubmesh.size());
        for (CalCoreSubmesh submesh : vectorCoreSubmesh) {
            CalSaver.saveCoreSubmesh(out, submesh);
        }
    }

    public static void saveCoreSkeleton(OutputStream file, CalCoreSkeleton coreSkeleton) throws IOException {
        LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(file);
        out.write(CalLoader.SKELETON_FILE_MAGIC);
        out.writeInt(1000);
        out.writeInt(coreSkeleton.getCoreBones().size());
        for (CalCoreBone bone : coreSkeleton.getCoreBones()) {
            CalSaver.saveCoreBones(out, bone);
        }
    }

    protected static void saveCoreSubmesh(DataOutput out, CalCoreSubmesh coreSubmesh) throws IOException {
        out.writeInt(coreSubmesh.getCoreMaterialThreadId());
        CalCoreSubmesh.VertexInfo[] vectorVertex = coreSubmesh.getVectorVertexInfo();
        Vector3fBuffer vertexPositions = coreSubmesh.getVertexPositions();
        Vector3fBuffer vertexNormals = coreSubmesh.getVertexNormals();
        CalCoreSubmesh.Face[] vectorFace = coreSubmesh.getVectorFace();
        float[] vectorPhysicalProperty = coreSubmesh.getVectorPhysicalProperty();
        CalCoreSubmesh.Spring[] vectorSpring = coreSubmesh.getVectorSpring();
        out.writeInt(vectorVertex.length);
        out.writeInt(vectorFace.length);
        out.writeInt(coreSubmesh.getLodCount());
        out.writeInt(coreSubmesh.getSpringCount());
        TexCoord2fBuffer[] textureCoordinates = coreSubmesh.getTextureCoordinates();
        out.writeInt(textureCoordinates.length);
        int vertexId = 0;
        while (vertexId < vectorVertex.length) {
            CalCoreSubmesh.VertexInfo vertexInfo = vectorVertex[vertexId];
            Vector3f vertexPosition = vertexPositions.get(vertexId);
            Vector3f vertexNormal = vertexNormals.get(vertexId);
            out.writeFloat(vertexPosition.getX());
            out.writeFloat(vertexPosition.getY());
            out.writeFloat(vertexPosition.getZ());
            out.writeFloat(vertexNormal.getX());
            out.writeFloat(vertexNormal.getY());
            out.writeFloat(vertexNormal.getZ());
            out.writeInt(vertexInfo.collapseId);
            out.writeInt(vertexInfo.faceCollapseCount);
            int textureCoordinateId = 0;
            while (textureCoordinateId < textureCoordinates.length) {
                Vector2f texCoord = textureCoordinates[textureCoordinateId].get(vertexId);
                out.writeFloat(texCoord.getX());
                out.writeFloat(texCoord.getY());
                ++textureCoordinateId;
            }
            out.writeInt(vertexInfo.influenceBoneIds.length);
            int influenceId = 0;
            while (influenceId < vertexInfo.influenceBoneIds.length) {
                out.writeInt(vertexInfo.influenceBoneIds[influenceId]);
                out.writeFloat(vertexInfo.influenceWeights[influenceId]);
                ++influenceId;
            }
            if (coreSubmesh.getSpringCount() > 0) {
                out.writeFloat(vectorPhysicalProperty[vertexId]);
            }
            ++vertexId;
        }
        int springId = 0;
        while (springId < coreSubmesh.getSpringCount()) {
            CalCoreSubmesh.Spring spring = vectorSpring[springId];
            out.writeInt(spring.vertexId0);
            out.writeInt(spring.vertexId1);
            out.writeFloat(spring.springCoefficient);
            out.writeFloat(spring.idleLength);
            ++springId;
        }
        int faceId = 0;
        while (faceId < vectorFace.length) {
            CalCoreSubmesh.Face face = vectorFace[faceId];
            out.writeInt(face.vertexId[0]);
            out.writeInt(face.vertexId[1]);
            out.writeInt(face.vertexId[2]);
            ++faceId;
        }
    }

    protected static void saveCoreTrack(DataOutput file, CalCoreTrack coreTrack) throws IOException {
        file.writeInt(coreTrack.getCoreBoneId());
        SortedSet<CalCoreKeyframe> mapCoreKeyframe = coreTrack.getCoreKeyFrames();
        file.writeInt(mapCoreKeyframe.size());
        for (CalCoreKeyframe keyframe : mapCoreKeyframe) {
            CalSaver.saveCoreKeyframe(file, keyframe);
        }
    }
}

