/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import org.jagatoo.loaders.models.cal3d.buffer.Vector3fBuffer;
import org.jagatoo.loaders.models.cal3d.core.CalCoreModel;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.jagatoo.loaders.models.cal3d.core.CalMesh;
import org.jagatoo.loaders.models.cal3d.core.CalModel;
import org.jagatoo.loaders.models.cal3d.core.CalSubmesh;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class CalSpringSystem {
    protected CalModel model;
    protected Vector3f gravity = new Vector3f(0.0f, 0.0f, -9.81f);
    protected Vector3f force = new Vector3f(0.0f, 0.05f, 0.0f);
    protected boolean collisionEnabled = false;
    public static final int ITERATION_COUNT = 2;

    public CalSpringSystem(CalModel model) {
        this.model = model;
        CalCoreModel coreModel = model.getCoreModel();
        if (coreModel == null) {
            throw new IllegalArgumentException();
        }
    }

    public void calculateForces(CalSubmesh submesh, float deltaTime) {
        CalSubmesh.PhysicalProperty[] vectorPhysicalProperty = submesh.getVectorPhysicalProperty();
        float[] vectorCorePhysicalProperty = submesh.getCoreSubmesh().getVectorPhysicalProperty();
        Vector3f f = new Vector3f();
        int vertexId = 0;
        while (vertexId < vectorPhysicalProperty.length) {
            CalSubmesh.PhysicalProperty physicalProperty = vectorPhysicalProperty[vertexId];
            float corePhysicalProperty = vectorCorePhysicalProperty[vertexId];
            if (corePhysicalProperty > 0.0f) {
                f.set((TupleNf)this.gravity);
                f.scale(corePhysicalProperty);
                f.add((TupleNf)this.force);
                physicalProperty.force.set((TupleNf)f);
            }
            ++vertexId;
        }
    }

    public void calculateVertices(CalSubmesh submesh, float deltaTime) {
        Vector3fBuffer vertexPositions = submesh.getVertexPositions();
        CalSubmesh.PhysicalProperty[] vectorPhysicalProperty = submesh.getVectorPhysicalProperty();
        float[] vectorCorePhysicalProperty = submesh.getCoreSubmesh().getVectorPhysicalProperty();
        Vector3f vertex = new Vector3f();
        Vector3f position = new Vector3f();
        Vector3f delta = new Vector3f();
        int vertexId = 0;
        while (vertexId < vectorPhysicalProperty.length) {
            CalSubmesh.PhysicalProperty physicalProperty = vectorPhysicalProperty[vertexId];
            float corePhysicalProperty = vectorCorePhysicalProperty[vertexId];
            position.set((TupleNf)physicalProperty.position);
            if (corePhysicalProperty > 0.0f) {
                delta.sub((TupleNf)position, (TupleNf)physicalProperty.positionOld);
                delta.scale(0.99f);
                physicalProperty.position.add((TupleNf)delta);
                delta.set((TupleNf)physicalProperty.force);
                delta.scale(1.0f / corePhysicalProperty * deltaTime * deltaTime);
                physicalProperty.position.add((TupleNf)delta);
            } else {
                vertexPositions.get(vertexId, vertex);
                physicalProperty.position.set((TupleNf)vertex);
            }
            physicalProperty.positionOld.set((TupleNf)position);
            vertexPositions.put(vertexId, physicalProperty.position);
            physicalProperty.force.set(0.0f, 0.0f, 0.0f);
            ++vertexId;
        }
        CalCoreSubmesh.Spring[] vectorSpring = submesh.getCoreSubmesh().getVectorSpring();
        Vector3f springVertex0 = new Vector3f();
        Vector3f springVertex1 = new Vector3f();
        Vector3f distance = new Vector3f();
        Vector3f tmp = new Vector3f();
        int iterationCount = 0;
        while (iterationCount < 2) {
            int iteratorSpring = 0;
            while (iteratorSpring != vectorSpring.length) {
                CalCoreSubmesh.Spring spring = vectorSpring[iteratorSpring];
                vertexPositions.get(spring.vertexId0, springVertex0);
                vertexPositions.get(spring.vertexId1, springVertex1);
                distance.sub((TupleNf)springVertex1, (TupleNf)springVertex0);
                float length = distance.length();
                if (length > 0.0f) {
                    float factor0;
                    float factor1 = factor0 = (length - spring.idleLength) / length;
                    if (vectorCorePhysicalProperty[spring.vertexId0] > 0.0f) {
                        factor0 /= 2.0f;
                        factor1 /= 2.0f;
                    } else {
                        factor0 = 0.0f;
                    }
                    if (vectorCorePhysicalProperty[spring.vertexId1] <= 0.0f) {
                        factor0 *= 2.0f;
                        factor1 = 0.0f;
                    }
                    tmp.set((TupleNf)distance);
                    tmp.scale(factor0);
                    springVertex0.add((TupleNf)tmp);
                    vectorPhysicalProperty[spring.vertexId0].position.set((TupleNf)springVertex0);
                    tmp.set((TupleNf)distance);
                    tmp.scale(factor1);
                    springVertex1.sub((TupleNf)tmp);
                    vectorPhysicalProperty[spring.vertexId1].position.set((TupleNf)springVertex1);
                    vertexPositions.put(spring.vertexId0, springVertex0);
                    vertexPositions.put(spring.vertexId1, springVertex1);
                }
                ++iteratorSpring;
            }
            ++iterationCount;
        }
    }

    public void update(float deltaTime) {
        for (CalMesh mesh : this.model.getMeshes()) {
            for (CalSubmesh submesh : mesh.getSubmeshes()) {
                if (submesh.getCoreSubmesh().getSpringCount() <= 0) continue;
                this.calculateForces(submesh, deltaTime);
                this.calculateVertices(submesh, deltaTime);
            }
        }
    }

    public Vector3f getGravity() {
        return this.gravity;
    }

    public void setGravity(Vector3f gravity) {
        this.gravity = gravity;
    }

    public Vector3f getForce() {
        return this.force;
    }

    public void setForce(Vector3f force) {
        this.force = force;
    }

    public boolean isCollisionEnabled() {
        return this.collisionEnabled;
    }

    public void setCollisionEnabled(boolean collisionEnabled) {
        this.collisionEnabled = collisionEnabled;
    }
}

