/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import org.jagatoo.loaders.models.cal3d.buffer.IndexBuffer;
import org.jagatoo.loaders.models.cal3d.buffer.ScalarfBuffer;
import org.jagatoo.loaders.models.cal3d.buffer.Vector3fBuffer;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class CalSubmesh {
    protected CalCoreSubmesh coreSubmesh;
    protected Vector3fBuffer vertexPositions;
    protected Vector3fBuffer vertexNormals;
    protected Vector3fBuffer[] vertexTangents;
    protected ScalarfBuffer[] vertexTangentCrossFactors;
    protected IndexBuffer faceIndices;
    protected float[] vectorMorphTargetWeight;
    protected PhysicalProperty[] vectorPhysicalProperty;
    protected int vertexCount;
    protected int faceCount;
    protected CalCoreMaterial coreMaterial;
    protected boolean internalData;

    public CalSubmesh(CalCoreSubmesh coreSubmesh) {
        if (coreSubmesh == null) {
            throw new IllegalArgumentException();
        }
        this.coreSubmesh = coreSubmesh;
        this.faceIndices = new IndexBuffer(3 * coreSubmesh.getFaceCount());
        this.setLodLevel(1.0f);
        this.coreMaterial = null;
        this.vectorMorphTargetWeight = new float[coreSubmesh.getCoreSubMorphTargetCount()];
        if (coreSubmesh.getSpringCount() > 0) {
            this.vertexPositions = new Vector3fBuffer(coreSubmesh.getVertexCount());
            this.vertexNormals = new Vector3fBuffer(coreSubmesh.getVertexCount());
            this.vertexTangents = new Vector3fBuffer[coreSubmesh.getTextureCoordinates().length];
            this.vertexTangentCrossFactors = new ScalarfBuffer[coreSubmesh.getTextureCoordinates().length];
            this.vectorPhysicalProperty = new PhysicalProperty[coreSubmesh.getVertexCount()];
            int n = 0;
            while (n < this.vectorPhysicalProperty.length) {
                this.vectorPhysicalProperty[n] = new PhysicalProperty();
                ++n;
            }
            Vector3fBuffer coreVertexPositions = coreSubmesh.getVertexPositions();
            Vector3fBuffer coreVertexNormals = coreSubmesh.getVertexNormals();
            Vector3f position = new Vector3f();
            Vector3f normal = new Vector3f();
            int vertexId = 0;
            while (vertexId < coreSubmesh.getVertexCount()) {
                coreVertexPositions.get(vertexId, position);
                this.vertexPositions.put(vertexId, position);
                this.vectorPhysicalProperty[vertexId].position.set((TupleNf)position);
                this.vectorPhysicalProperty[vertexId].positionOld.set((TupleNf)position);
                coreVertexNormals.get(vertexId, normal);
                this.vertexNormals.put(vertexId, normal);
                ++vertexId;
            }
            this.internalData = true;
        } else {
            this.internalData = false;
        }
    }

    public CalCoreMaterial getCoreMaterial() {
        return this.coreMaterial;
    }

    public CalCoreSubmesh getCoreSubmesh() {
        return this.coreSubmesh;
    }

    public int getFaceCount() {
        return this.faceCount;
    }

    public IndexBuffer getFaceIndices() {
        return this.faceIndices;
    }

    public Vector3fBuffer getVertexNormals() {
        return this.vertexNormals;
    }

    public Vector3fBuffer getVertexTangents(int mapId) {
        return this.vertexTangents == null ? null : this.vertexTangents[mapId];
    }

    public int getVertexTangentsMapCount() {
        return this.vertexTangents == null ? 0 : this.vertexTangents.length;
    }

    public PhysicalProperty[] getVectorPhysicalProperty() {
        return this.vectorPhysicalProperty;
    }

    public Vector3fBuffer getVertexPositions() {
        return this.vertexPositions;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public boolean hasInternalData() {
        return this.internalData;
    }

    public void disableInternalData() {
        if (this.internalData) {
            this.vertexPositions = null;
            this.vertexNormals = null;
            this.vertexTangents = null;
            this.vertexTangentCrossFactors = null;
            this.vectorPhysicalProperty = null;
            this.internalData = false;
        }
    }

    public boolean isTangentsEnabled(int mapId) {
        return this.coreSubmesh.isTangentsEnabled(mapId);
    }

    public void setTangentsEnabled(int mapId, boolean enabled) {
        this.coreSubmesh.setTangentsEnabled(mapId, enabled);
        if (!this.internalData) {
            return;
        }
        if (!enabled) {
            this.vertexTangents = null;
            this.vertexTangentCrossFactors = null;
            return;
        }
        this.vertexTangents[mapId] = new Vector3fBuffer(this.coreSubmesh.getVertexCount());
        this.vertexTangentCrossFactors[mapId] = new ScalarfBuffer(this.coreSubmesh.getVertexCount());
        this.vertexTangents[mapId].set(this.coreSubmesh.getVertexTangents(mapId));
        this.vertexTangentCrossFactors[mapId].set(this.coreSubmesh.getVertexTangentCrossFactors(mapId));
    }

    public void setCoreMaterial(CalCoreMaterial coreMaterial) {
        this.coreMaterial = coreMaterial;
    }

    public void setLodLevel(float lodLevel) {
        if (lodLevel < 0.0f) {
            lodLevel = 0.0f;
        }
        if (lodLevel > 1.0f) {
            lodLevel = 1.0f;
        }
        int lodCount = this.coreSubmesh.getLodCount();
        lodCount = (int)((1.0f - lodLevel) * (float)lodCount);
        this.vertexCount = this.coreSubmesh.getVertexCount() - lodCount;
        CalCoreSubmesh.Face[] vectorFace = this.coreSubmesh.getVectorFace();
        CalCoreSubmesh.VertexInfo[] vectorVertex = this.coreSubmesh.getVectorVertexInfo();
        this.faceCount = vectorFace.length;
        int vertexId = vectorVertex.length - 1;
        while (vertexId >= this.vertexCount) {
            this.faceCount -= vectorVertex[vertexId].faceCollapseCount;
            --vertexId;
        }
        int faceId = 0;
        while (faceId < this.faceCount) {
            CalCoreSubmesh.Face face = vectorFace[faceId];
            int vertexId2 = 0;
            while (vertexId2 < 3) {
                int collapsedVertexId = face.vertexId[vertexId2];
                while (collapsedVertexId >= this.vertexCount) {
                    collapsedVertexId = vectorVertex[collapsedVertexId].collapseId;
                }
                this.faceIndices.put(3 * faceId + vertexId2, collapsedVertexId);
                ++vertexId2;
            }
            ++faceId;
        }
    }

    public void setMorphTargetWeight(int blendId, float weight) {
        this.vectorMorphTargetWeight[blendId] = weight;
    }

    public float getMorphTargetWeight(int blendId) {
        return this.vectorMorphTargetWeight[blendId];
    }

    public float getBaseWeight() {
        float baseWeight = 1.0f;
        int morphTargetCount = this.getMorphTargetWeightCount();
        int morphTargetId = 0;
        while (morphTargetId < morphTargetCount) {
            baseWeight -= this.vectorMorphTargetWeight[morphTargetId];
            ++morphTargetId;
        }
        return baseWeight;
    }

    public float[] getVectorMorphTargetWeight() {
        return this.vectorMorphTargetWeight;
    }

    public int getMorphTargetWeightCount() {
        return this.vectorMorphTargetWeight.length;
    }

    public class PhysicalProperty {
        Vector3f position = new Vector3f();
        Vector3f positionOld = new Vector3f();
        Vector3f force = new Vector3f();
    }
}

