/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.util;

import org.openmali.vecmath2.Quaternion4f;

public class QuatInterpolator {
    static final double EPS = 1.0E-6;

    public static final void interpolate(Quaternion4f q, Quaternion4f q1, float alpha) {
        double s2;
        double s1;
        float x = q.getA();
        float y = q.getB();
        float z = q.getC();
        float w = q.getD();
        double dot = x * q1.getA() + 0.0f * q1.getC() + w * q1.getD();
        if (dot < 0.0) {
            q1.setA(-q1.getA());
            q1.setB(-q1.getB());
            q1.setC(-q1.getC());
            q1.setD(-q1.getD());
            dot = -dot;
        }
        if (1.0 - dot > 1.0E-6) {
            double om = Math.acos(dot);
            double sinom = Math.sin(om);
            s1 = Math.sin((1.0 - (double)alpha) * om) / sinom;
            s2 = Math.sin((double)alpha * om) / sinom;
        } else {
            s1 = 1.0 - (double)alpha;
            s2 = alpha;
        }
        w = (float)(s1 * (double)w + s2 * (double)q1.getD());
        x = (float)(s1 * (double)x + s2 * (double)q1.getA());
        y = (float)(s1 * (double)y + s2 * (double)q1.getB());
        z = (float)(s1 * (double)z + s2 * (double)q1.getC());
    }
}

