/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.LibraryAnimationsLoader;
import org.jagatoo.loaders.models.collada.LibraryControllersLoader;
import org.jagatoo.loaders.models.collada.LibraryEffectsLoader;
import org.jagatoo.loaders.models.collada.LibraryGeometriesLoader;
import org.jagatoo.loaders.models.collada.LibraryImagesLoader;
import org.jagatoo.loaders.models.collada.LibraryMaterialsLoader;
import org.jagatoo.loaders.models.collada.LibraryVisualScenesLoader;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.ColladaProtoypeModel;
import org.jagatoo.loaders.models.collada.stax.XMLCOLLADA;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryAnimations;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryControllers;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryEffects;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryGeometries;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryImages;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryMaterials;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryVisualScenes;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.ParsingException;

public class COLLADALoader {
    private static final XMLInputFactory factory = XMLInputFactory.newInstance();

    static {
        factory.setProperty("javax.xml.stream.isCoalescing", true);
    }

    public AssetFolder load(URL basePath, InputStream stream) {
        long t1 = System.nanoTime();
        AssetFolder colladaFile = new AssetFolder(basePath);
        try {
            ArrayList<XMLLibraryAnimations> libraryAnimationsList;
            ArrayList<XMLLibraryMaterials> libraryMaterialsList;
            ArrayList<XMLLibraryVisualScenes> libraryVisualScenesList;
            ArrayList<XMLLibraryImages> libraryImagesList;
            ArrayList<XMLLibraryEffects> libraryEffectsList;
            ArrayList<XMLLibraryControllers> libraryControllersList;
            XMLCOLLADA collada;
            long l1;
            block23: {
                JAGTLog.debug("TT] Parsing...");
                JAGTLog.increaseIndentation();
                l1 = System.nanoTime();
                XMLStreamReader reader = factory.createXMLStreamReader(stream);
                collada = new XMLCOLLADA();
                try {
                    collada.parse(reader);
                }
                catch (XMLStreamException e) {
                    System.out.println(reader.getLocation().toString());
                    e.printStackTrace();
                    reader.close();
                    break block23;
                }
                catch (NumberFormatException e) {
                    try {
                        System.out.println(reader.getLocation().toString());
                        e.printStackTrace();
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        reader.close();
                    }
                }
                reader.close();
            }
            long l2 = System.nanoTime();
            JAGTLog.debug("TT] Took ", (l2 - l1) / 1000000L, " milliseconds to parse");
            JAGTLog.decreaseIndentation();
            JAGTLog.debug("--] This is a COLLADA ", collada.version, " file");
            JAGTLog.debug("--] Note that the loader don't care whether it's 1.4.0 or 1.4.1, though", "\n the COLLADA schema used for parsing is the for 1.4.1, tests for development", "\n have been done with 1.4.0 files exported by Blender (Illusoft script)");
            JAGTLog.debug("TT] Exploring libraries...");
            JAGTLog.increaseIndentation();
            ArrayList<XMLLibraryGeometries> libraryGeometriesList = collada.libraryGeometries;
            if (libraryGeometriesList != null) {
                for (XMLLibraryGeometries libraryGeometries : libraryGeometriesList) {
                    JAGTLog.debug("CC] Found LibraryGeometries ! We know that !");
                    JAGTLog.increaseIndentation();
                    LibraryGeometriesLoader.loadLibraryGeometries(colladaFile, libraryGeometries);
                    JAGTLog.decreaseIndentation();
                }
            }
            if ((libraryControllersList = collada.libraryControllers) != null) {
                for (XMLLibraryControllers libraryControllers : libraryControllersList) {
                    JAGTLog.debug("CC] Found LibraryControllers ! Investigating... !");
                    JAGTLog.increaseIndentation();
                    LibraryControllersLoader.loadLibraryControllers(colladaFile, libraryControllers);
                    JAGTLog.decreaseIndentation();
                }
            }
            if ((libraryEffectsList = collada.libraryEffects) != null) {
                for (XMLLibraryEffects libraryEffects : libraryEffectsList) {
                    JAGTLog.debug("CC] Found LibraryEffects ! Investigating... !");
                    JAGTLog.increaseIndentation();
                    LibraryEffectsLoader.loadLibraryEffects(colladaFile, libraryEffects);
                    JAGTLog.decreaseIndentation();
                }
            }
            if ((libraryImagesList = collada.libraryImages) != null) {
                for (XMLLibraryImages libraryImages : libraryImagesList) {
                    JAGTLog.debug("CC] Found LibraryImages ! We know that !");
                    JAGTLog.increaseIndentation();
                    LibraryImagesLoader.loadLibraryImages(colladaFile, libraryImages);
                    JAGTLog.decreaseIndentation();
                }
            }
            if ((libraryVisualScenesList = collada.libraryVisualScenes) != null) {
                for (XMLLibraryVisualScenes libraryVisualScenes : libraryVisualScenesList) {
                    JAGTLog.debug("CC] Found LibraryVisualScenes ! Investigating... !");
                    JAGTLog.increaseIndentation();
                    LibraryVisualScenesLoader.loadLibraryVisualScenes(colladaFile, libraryVisualScenes, collada.asset.getUpVector());
                    JAGTLog.decreaseIndentation();
                }
            }
            if ((libraryMaterialsList = collada.libraryMaterials) != null) {
                for (XMLLibraryMaterials libraryMaterials : libraryMaterialsList) {
                    JAGTLog.debug("CC] Found LibraryMaterials ! We know that !");
                    JAGTLog.increaseIndentation();
                    LibraryMaterialsLoader.loadLibraryMaterials(colladaFile, libraryMaterials);
                    JAGTLog.decreaseIndentation();
                }
            }
            if ((libraryAnimationsList = collada.libraryAnimations) != null) {
                for (XMLLibraryAnimations libraryAnimations : libraryAnimationsList) {
                    JAGTLog.debug("CC] Found LibraryAnimations ! We should know that !");
                    JAGTLog.increaseIndentation();
                    LibraryAnimationsLoader.loadLibraryAnimations(colladaFile, libraryAnimations);
                    JAGTLog.decreaseIndentation();
                }
            }
            JAGTLog.decreaseIndentation();
            colladaFile.setModel(new ColladaProtoypeModel(colladaFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long t2 = System.nanoTime();
        JAGTLog.debug("TT] Took ", (t2 - t1) / 1000L / 1000L, " milliseconds to load.");
        return colladaFile;
    }
}

