/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import java.util.Collection;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.controllers.SkeletalController;
import org.jagatoo.loaders.models.collada.stax.XMLController;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryControllers;
import org.jagatoo.logging.JAGTLog;

public class LibraryControllersLoader {
    static void loadLibraryControllers(AssetFolder colladaFile, XMLLibraryControllers controllers) {
        Collection<XMLController> controllersList = controllers.controllers.values();
        for (XMLController controller : controllersList) {
            String source = controller.skin.source.replaceAll(" ", "_");
            String id = controller.id;
            JAGTLog.debug("TT] Found controller with Id : \"", id, "\" and source : \"", String.valueOf(source) + "\"");
            colladaFile.getLibraryControllers().getControllers().put(id, new SkeletalController(colladaFile.getLibraryGeometries(), source, controller, colladaFile.getLibraryAnimations(), colladaFile.getLibraryVisualsScenes().getSkeletons().get(id.replace("-skin", ""))));
        }
    }
}

