/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada;

import java.util.Collection;
import java.util.HashMap;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.materials.LibraryMaterials;
import org.jagatoo.loaders.models.collada.datastructs.materials.Material;
import org.jagatoo.loaders.models.collada.stax.XMLLibraryMaterials;
import org.jagatoo.loaders.models.collada.stax.XMLMaterial;
import org.jagatoo.logging.JAGTLog;

public class LibraryMaterialsLoader {
    static void loadLibraryMaterials(AssetFolder colladaFile, XMLLibraryMaterials libMaterials) {
        LibraryMaterials colLibMaterials = colladaFile.getLibraryMaterials();
        HashMap<String, Material> colMaterials = colLibMaterials.getMaterials();
        Collection<XMLMaterial> materials = libMaterials.materials.values();
        JAGTLog.increaseIndentation();
        for (XMLMaterial material : materials) {
            Material colMaterial = new Material(colladaFile, material.id, material.instanceEffect.url);
            JAGTLog.debug("TT] Found material [", colMaterial.getId(), ":", colMaterial.getEffect(), "]");
            colMaterials.put(colMaterial.getId(), colMaterial);
        }
        JAGTLog.decreaseIndentation();
    }
}

