/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.datastructs.animation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jagatoo.loaders.models.collada.datastructs.animation.Bone;
import org.jagatoo.loaders.models.collada.datastructs.animation.Skeleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletonIterator
implements Iterator<Bone> {
    private final Skeleton skeleton;
    private final ArrayList<Bone> bones = new ArrayList();
    private int currentIndex;

    @Override
    public boolean hasNext() {
        return this.currentIndex + 1 < this.bones.size();
    }

    @Override
    public Bone next() {
        return this.bones.get(++this.currentIndex);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove a bone");
    }

    private void fillBoneList(Bone bone, List<Bone> boneList) {
        boneList.add(bone);
        int i = 0;
        while (i < bone.numChildren()) {
            this.fillBoneList(bone.getChild(i), boneList);
            ++i;
        }
    }

    public void reset() {
        Bone bone = this.skeleton.getRootBone();
        this.bones.clear();
        this.fillBoneList(bone, this.bones);
        this.currentIndex = -1;
    }

    public SkeletonIterator(Skeleton skeleton) {
        this.skeleton = skeleton;
    }
}

