/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.datastructs.controllers;

import java.util.List;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrame;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameQuat4f;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameTuple3f;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.util.Interpolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyFrameComputer {
    public static void computeTuple3f(long currentTime, List<KeyFrameTuple3f> keyFrames, Tuple3f toInterpolate) {
        int frame = 0;
        if (keyFrames == null || frame >= keyFrames.size()) {
            return;
        }
        frame = KeyFrame.searchNextFrame(keyFrames, currentTime);
        if (frame == 0) {
            toInterpolate.set((TupleNf)keyFrames.get(frame).getValue());
        } else if (frame == keyFrames.size()) {
            toInterpolate.set((TupleNf)keyFrames.get(frame - 1).getValue());
        } else {
            JAGTLog.debug("Interpolating...");
            KeyFrameTuple3f prevFrame = keyFrames.get(frame - 1);
            KeyFrameTuple3f nextFrame = keyFrames.get(frame);
            long timeDist = nextFrame.time - prevFrame.time;
            float delta = (currentTime - prevFrame.time) / timeDist;
            Interpolation.interpolate((Tuple3f)prevFrame.getValue(), (Tuple3f)nextFrame.getValue(), (float)delta, (Tuple3f)toInterpolate);
        }
    }

    public static void computeQuaternion4f(long currentTime, List<KeyFrameQuat4f> keyFrames, Quaternion4f toInterpolate) {
        int frame = KeyFrame.searchNextFrame(keyFrames, currentTime);
        JAGTLog.debug("Frame = ", frame);
        if (frame == 0) {
            toInterpolate.set((TupleNf)keyFrames.get(frame).getValue());
        } else if (frame == keyFrames.size()) {
            toInterpolate.set((TupleNf)keyFrames.get(frame - 1).getValue());
        } else {
            KeyFrameQuat4f prevFrame = keyFrames.get(frame - 1);
            KeyFrameQuat4f nextFrame = keyFrames.get(frame);
            long timeDist = nextFrame.time - prevFrame.time;
            float delta = (currentTime - prevFrame.time) / timeDist;
            Interpolation.nlerp((Quaternion4f)prevFrame.getValue(), (Quaternion4f)nextFrame.getValue(), (float)delta, (Quaternion4f)toInterpolate);
        }
    }
}

