/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.datastructs.controllers;

import java.util.HashMap;
import java.util.Map;
import org.jagatoo.loaders.models.collada.AnimatableModel;
import org.jagatoo.loaders.models.collada.COLLADAAction;
import org.jagatoo.loaders.models.collada.datastructs.ColladaProtoypeModel;
import org.jagatoo.loaders.models.collada.datastructs.animation.Bone;
import org.jagatoo.loaders.models.collada.datastructs.animation.LibraryAnimations;
import org.jagatoo.loaders.models.collada.datastructs.animation.Skeleton;
import org.jagatoo.loaders.models.collada.datastructs.controllers.Controller;
import org.jagatoo.loaders.models.collada.datastructs.controllers.Influence;
import org.jagatoo.loaders.models.collada.datastructs.controllers.KeyFrameComputer;
import org.jagatoo.loaders.models.collada.datastructs.geometries.Geometry;
import org.jagatoo.loaders.models.collada.datastructs.geometries.LibraryGeometries;
import org.jagatoo.loaders.models.collada.datastructs.geometries.Mesh;
import org.jagatoo.loaders.models.collada.datastructs.geometries.MeshSources;
import org.jagatoo.loaders.models.collada.datastructs.geometries.TrianglesGeometry;
import org.jagatoo.loaders.models.collada.stax.XMLController;
import org.jagatoo.loaders.models.collada.stax.XMLSkin;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletalController
extends Controller
implements AnimatableModel {
    private final String sourceMeshId;
    private Geometry sourceGeom;
    private Skeleton skeleton;
    private HashMap<String, COLLADAAction> actions = new HashMap();
    public LibraryAnimations libAnims;
    private COLLADAAction currentAction;
    private boolean loop = false;
    private long currentTime = -1L;
    private boolean playing = false;
    private boolean bonesPrepared = false;
    private Iterable<Bone> boneIt = this.skeleton;

    public SkeletalController(LibraryGeometries libGeoms, String sourceMeshId, XMLController controller, LibraryAnimations libAnims, Skeleton skel) {
        super(libGeoms, controller);
        this.sourceMeshId = sourceMeshId;
        this.skeleton = skel;
        this.libAnims = libAnims;
        this.sourceGeom = libGeoms.getGeometries().get(sourceMeshId);
    }

    public String getSourceMeshId() {
        return this.sourceMeshId;
    }

    @Override
    public void play(COLLADAAction action, boolean loop) {
        this.currentAction = action;
        this.currentAction.prepareBones();
        this.bonesPrepared = true;
        this.skeleton = this.currentAction.getSkeleton();
        this.loop = loop;
        this.skeleton.resetIterator();
        this.boneIt = this.skeleton;
        this.currentTime = 0L;
        this.playing = true;
    }

    private static final void readVertexCoord(float[] vertexCoordData, int dataOffset, Point3f coord) {
        coord.set(vertexCoordData[dataOffset + 0], vertexCoordData[dataOffset + 1], vertexCoordData[dataOffset + 2]);
    }

    private static final void writeVertexCoord(Point3f coord, float[] vertexCoordData, int dataOffset) {
        vertexCoordData[dataOffset + 0] = coord.getX();
        vertexCoordData[dataOffset + 1] = coord.getY();
        vertexCoordData[dataOffset + 2] = coord.getZ();
    }

    @Override
    public Geometry updateDestinationGeometry(long currTime) {
        if (this.sourceGeom == null) {
            this.sourceGeom = this.getLibraryGeometries().getGeometries().get(this.sourceMeshId);
            if (!(this.sourceGeom instanceof TrianglesGeometry)) {
                throw new Error("Only TrianglesGeometry is supported for now ! Make sure, your model is triangulated when exporting from your modeling tool.");
            }
            this.destinationGeometry = this.sourceGeom.copy();
        }
        if (!this.playing) {
            return this.destinationGeometry;
        }
        if (this.skeleton == null) {
            JAGTLog.debug("Hey ! We haven't been initialized yet... Darn.");
        } else {
            JAGTLog.debug("Our skeleton root bone is named \"", this.skeleton.getRootBone().getName(), "\"");
            this.currentTime = currTime;
            KeyFrameComputer.computeTuple3f(this.currentTime, this.skeleton.transKeyFrames, (Tuple3f)this.skeleton.relativeTranslation);
            if (this.currentAction == null) {
                return this.destinationGeometry;
            }
            if (!this.bonesPrepared) {
                this.currentAction.prepareBones();
                this.skeleton = this.currentAction.getSkeleton();
            }
            this.boneIt = this.skeleton;
            for (Bone bone : this.boneIt) {
                if (!bone.hasKeyFrames()) {
                    JAGTLog.debug("no keyframes!");
                    bone.setNoRelativeMovement();
                    continue;
                }
                JAGTLog.debug("Keyframes");
                KeyFrameComputer.computeTuple3f(this.currentTime, bone.scaleKeyFrames, bone.relativeScaling);
                KeyFrameComputer.computeQuaternion4f(this.currentTime, bone.rotKeyFrames, bone.relativeRotation);
            }
            this.skeleton.updateAbsolutes();
        }
        Mesh mesh = this.sourceGeom.getMesh();
        MeshSources sources = mesh.getSources();
        XMLSkin skin = this.getController().skin;
        this.destinationGeometry = this.sourceGeom.copy();
        MeshSources targets = this.destinationGeometry.getMesh().getSources();
        int numVertices = sources.getVertices().length / 3;
        skin.buildInfluences(this.skeleton, numVertices);
        Point3f coord0 = Point3f.fromPool();
        Point3f coordTrans = Point3f.fromPool();
        Point3f coord1 = Point3f.fromPool();
        int vi = 0;
        while (vi < numVertices) {
            Influence[] influences = skin.getInfluencesForVertex(vi);
            if (influences.length > 0) {
                int vi3 = vi * 3;
                SkeletalController.readVertexCoord(sources.getVertices(), vi3, coord0);
                coord1.setZero();
                int ii = 0;
                while (ii < influences.length) {
                    Influence influence = influences[ii];
                    coordTrans.set((TupleNf)coord0);
                    influence.getMatrix().transform(coordTrans);
                    coord1.add((TupleNf)coordTrans);
                    ++ii;
                }
                SkeletalController.writeVertexCoord(coord1, targets.getVertices(), vi3);
            }
            ++vi;
        }
        Point3f.toPool((Point3f)coord1);
        Point3f.toPool((Point3f)coordTrans);
        Point3f.toPool((Point3f)coord0);
        return this.destinationGeometry;
    }

    public void setSkeleton(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    @Override
    public final COLLADAAction getAction(String id) {
        return this.actions.get(id);
    }

    @Override
    public final HashMap<String, COLLADAAction> getActions() {
        return this.actions;
    }

    @Override
    public ColladaProtoypeModel getPrototypeModel() {
        return null;
    }

    @Override
    public final int numActions() {
        return this.actions.values().size();
    }

    @Override
    public final boolean hasActions() {
        return this.numActions() > 0;
    }

    @Override
    public final boolean isLooping() {
        return this.loop;
    }

    @Override
    public final boolean isPlaying() {
        return this.playing;
    }

    public void calcActions(String actionId) {
        for (Map.Entry<String, COLLADAAction> entry : this.libAnims.getAnimations().entrySet()) {
            if (!entry.getKey().equals(actionId)) continue;
            JAGTLog.debug("Action found");
            this.actions.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void play(String actionId, boolean loop) {
        this.calcActions(actionId);
        this.play(this.actions.get(actionId), loop);
    }

    @Override
    public void pause() {
        this.playing = false;
    }

    @Override
    public void resume() {
        this.playing = true;
    }
}

