/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLInstanceMaterial;
import org.jagatoo.logging.JAGTLog;

public class XMLBindMaterial {
    public TechniqueCommon techniqueCommon;

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.techniqueCommon == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing techniqueCommon.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("technique_common")) {
                        if (this.techniqueCommon != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " too many ", parser.getLocalName(), " tags.");
                        }
                        this.techniqueCommon = new TechniqueCommon();
                        this.techniqueCommon.parse(parser);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("bind_material")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    public static class TechniqueCommon {
        public ArrayList<XMLInstanceMaterial> instanceMaterials = new ArrayList();

        public void parse(XMLStreamReader parser) throws XMLStreamException {
            this.doParsing(parser);
            if (this.instanceMaterials.isEmpty()) {
                JAGTLog.exception(this.getClass().getSimpleName(), ": missing Instance Material.");
            }
        }

        private void doParsing(XMLStreamReader parser) throws XMLStreamException {
            int event = parser.next();
            while (event != 8) {
                switch (event) {
                    case 1: {
                        String localName = parser.getLocalName();
                        if (localName.equals("instance_material")) {
                            XMLInstanceMaterial instMat = new XMLInstanceMaterial();
                            instMat.parse(parser);
                            this.instanceMaterials.add(instMat);
                            break;
                        }
                        JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                        break;
                    }
                    case 2: {
                        if (!parser.getLocalName().equals("technique_common")) break;
                        return;
                    }
                }
                event = parser.next();
            }
        }
    }
}

