/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.StAXHelper;
import org.jagatoo.loaders.models.collada.stax.XMLColor4;
import org.jagatoo.loaders.models.collada.stax.XMLTexture;
import org.jagatoo.logging.JAGTLog;

public class XMLColorOrTexture {
    public XMLColor4 color4 = null;
    public XMLTexture texture = null;

    private void checkVars(String name) {
        if (this.color4 != null || this.texture != null) {
            JAGTLog.exception(this.getClass().getSimpleName(), " invalid ", name, " tag.");
        }
    }

    public void parse(XMLStreamReader parser, String endTag) throws XMLStreamException {
        this.doParsing(parser, endTag);
        Location loc = parser.getLocation();
        if (this.texture == null && this.color4 == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing texture or color.");
        }
    }

    private void doParsing(XMLStreamReader parser, String endTag) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("color")) {
                        this.checkVars("color");
                        this.color4 = new XMLColor4(StAXHelper.parseText(parser));
                        break;
                    }
                    if (localName.equals("texture")) {
                        this.checkVars("texture");
                        this.texture = new XMLTexture();
                        this.texture.parse(parser);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals(endTag)) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

