/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLIDREFUtils;
import org.jagatoo.logging.JAGTLog;

public class XMLIDREFArray {
    public int count;
    public String id;
    public String[] idrefs;

    public static String[] toArray(String idrefValues) {
        StringTokenizer tknz = new StringTokenizer(idrefValues);
        int count = tknz.countTokens();
        String[] idrefs = new String[count];
        int i = 0;
        while (i < count) {
            idrefs[i] = XMLIDREFUtils.parse(tknz.nextToken());
            ++i;
        }
        return idrefs;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("count")) {
                this.count = Integer.parseInt(parser.getAttributeValue(i).trim());
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 4: {
                    this.idrefs = XMLIDREFArray.toArray(parser.getText());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("IDREF_array")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

