/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLIDREFUtils;
import org.jagatoo.logging.JAGTLog;

public class XMLInput {
    public int offset = -1;
    public String semantic = null;
    public String source = null;

    public Semantic recognizeSemantic() {
        Semantic sem = Semantic.valueOf(this.semantic);
        if (sem == null) {
            sem = Semantic.OTHER;
        }
        return sem;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.semantic == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing semantic.");
        }
        if (this.source == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing source.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("offset")) {
                this.offset = Integer.parseInt(parser.getAttributeValue(i).trim());
            } else if (attr.getLocalPart().equals("semantic")) {
                this.semantic = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("source")) {
                this.source = XMLIDREFUtils.parse(parser.getAttributeValue(i));
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("input")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Semantic {
        VERTEX,
        NORMAL,
        TEXCOORD,
        COLOR,
        INPUT,
        OUTPUT,
        INTERPOLATION,
        JOINT,
        INV_BIND_MATRIX,
        WEIGHT,
        POSITION,
        OTHER;

    }
}

