/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLController;
import org.jagatoo.logging.JAGTLog;

public class XMLLibraryControllers {
    private ArrayList<XMLController> controllersList = new ArrayList();
    public HashMap<String, XMLController> controllers = null;

    public void readControllers() {
        this.controllers = new HashMap();
        for (XMLController controller : this.controllersList) {
            this.controllers.put(controller.id, controller);
        }
        this.controllersList = null;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.controllersList.isEmpty()) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing controllers.");
        }
        this.readControllers();
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("controller")) {
                        XMLController contr = new XMLController();
                        contr.parse(parser);
                        this.controllersList.add(contr);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("library_controllers")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

