/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.logging.JAGTLog;

public class XMLNameArray {
    public int count;
    public String id;
    public String[] names;

    public static String[] toArray(String nameValues) {
        StringTokenizer tknz = new StringTokenizer(nameValues);
        int count = tknz.countTokens();
        String[] names = new String[count];
        int i = 0;
        while (i < count) {
            names[i] = tknz.nextToken();
            ++i;
        }
        return names;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("count")) {
                this.count = Integer.parseInt(parser.getAttributeValue(i).trim());
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 4: {
                    this.names = XMLNameArray.toArray(parser.getText());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("Name_array")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

