/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLInput;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;

public class XMLSampler {
    public String id = null;
    public ArrayList<XMLInput> inputs = new ArrayList();

    public XMLInput getInput(String semantic) {
        for (XMLInput input : this.inputs) {
            if (!input.semantic.equals(semantic)) continue;
            return input;
        }
        throw new IncorrectFormatException("Could not find input with semantic " + semantic);
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("input")) {
                        XMLInput input = new XMLInput();
                        input.parse(parser);
                        if (input.offset != -1) {
                            JAGTLog.exception("Sampler inputs should not have an offset set.");
                        }
                        this.inputs.add(input);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("sampler")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

