/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.datastructs.animation.Bone;
import org.jagatoo.loaders.models.collada.datastructs.animation.Skeleton;
import org.jagatoo.loaders.models.collada.datastructs.controllers.Influence;
import org.jagatoo.loaders.models.collada.stax.StAXHelper;
import org.jagatoo.loaders.models.collada.stax.XMLIDREFUtils;
import org.jagatoo.loaders.models.collada.stax.XMLInput;
import org.jagatoo.loaders.models.collada.stax.XMLMatrix4x4;
import org.jagatoo.loaders.models.collada.stax.XMLMatrixUtils;
import org.jagatoo.loaders.models.collada.stax.XMLSource;
import org.jagatoo.loaders.models.collada.stax.XMLVertexWeights;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.openmali.vecmath2.Matrix4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSkin {
    private static final String SKIN_JOINTS_SOURCE = "skin-joints";
    private static final String SKIN_WEIGHTS_SOURCE = "skin-weights";
    public String source = null;
    public XMLMatrix4x4 bindShapeMatrix = null;
    public ArrayList<XMLSource> sources = new ArrayList();
    public ArrayList<XMLInput> jointsInputs = null;
    public XMLVertexWeights vertexWeights = null;
    private Influence[][] influences = null;

    public XMLSource getJointsSource() {
        for (XMLSource source : this.sources) {
            if (!source.id.endsWith(SKIN_JOINTS_SOURCE)) continue;
            return source;
        }
        throw new IncorrectFormatException("Could not find source skin-joints in library_controllers");
    }

    public XMLSource getWeightsSource() {
        for (XMLSource source : this.sources) {
            if (!source.id.endsWith(SKIN_WEIGHTS_SOURCE)) continue;
            return source;
        }
        throw new IncorrectFormatException("Could not find source skin-weights in library_controllers");
    }

    private void normalizeInfluences() {
    }

    public void buildInfluences(Skeleton skeleton, int numVertices) {
        if (this.influences != null) {
            return;
        }
        this.influences = new Influence[numVertices][];
        XMLSource jointsSource = this.getJointsSource();
        XMLSource weightsSource = this.getWeightsSource();
        int vIndex = 0;
        int i = 0;
        while (i < this.vertexWeights.vcount.ints.length) {
            int numBones = this.vertexWeights.vcount.ints[i];
            this.influences[i] = new Influence[numBones];
            int j = 0;
            while (j < numBones) {
                int boneIndex = this.vertexWeights.v.ints[vIndex + j * 2 + 0];
                int weightIndex = this.vertexWeights.v.ints[vIndex + j * 2 + 1];
                float weight = weightsSource.floatArray.floats[weightIndex];
                if (boneIndex == -1) {
                    this.influences[i][j] = new Influence(this.bindShapeMatrix.matrix4f, weight);
                } else {
                    String boneSourceId = jointsSource.idrefArray.idrefs[boneIndex];
                    Bone bone = skeleton.getBoneBySourceId(boneSourceId);
                    Matrix4f m = new Matrix4f(bone.getAbsoluteTransformation());
                    this.influences[i][j] = new Influence(m, weight);
                }
                ++j;
            }
            vIndex += numBones * 2;
            ++i;
        }
        this.normalizeInfluences();
    }

    public Influence[] getInfluencesForVertex(int vertexIndex) {
        return this.influences[vertexIndex];
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        if (this.source == null) {
            JAGTLog.exception(this.getClass().getSimpleName(), " missing attribute source.");
        }
        if (this.jointsInputs == null) {
            JAGTLog.exception(this.getClass().getSimpleName(), " missing joint.");
        }
        if (this.vertexWeights == null) {
            JAGTLog.exception(this.getClass().getSimpleName(), " missing vertex weights.");
        }
        if (this.sources.size() < 3) {
            JAGTLog.exception(this.getClass().getSimpleName(), " not enough sources.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("source")) {
                this.source = XMLIDREFUtils.parse(parser.getAttributeValue(i));
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("source")) {
                        XMLSource src = new XMLSource();
                        src.parse(parser);
                        this.sources.add(src);
                        break;
                    }
                    if (localName.equals("bind_shape_matrix")) {
                        if (this.bindShapeMatrix != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " too many bind_shape_matrix tags.");
                        }
                        this.bindShapeMatrix = XMLMatrixUtils.readColumnMajor(StAXHelper.parseText(parser));
                        break;
                    }
                    if (localName.equals("joints")) {
                        this.jointsInputs = this.getJointInputs(parser);
                        break;
                    }
                    if (localName.equals("vertex_weights")) {
                        this.vertexWeights = new XMLVertexWeights();
                        this.vertexWeights.parse(parser);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("skin")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    public ArrayList<XMLInput> getJointInputs(XMLStreamReader parser) throws XMLStreamException {
        ArrayList<XMLInput> inputs = new ArrayList<XMLInput>();
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("input")) {
                        XMLInput input = new XMLInput();
                        input.parse(parser);
                        inputs.add(input);
                    } else {
                        JAGTLog.exception("Unsupported XMLJoint Start tag: ", parser.getLocalName());
                    }
                }
                case 2: {
                    if (!parser.getLocalName().equals("joints")) break;
                    return inputs;
                }
            }
            event = parser.next();
        }
        return null;
    }
}

