/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLInput;
import org.jagatoo.loaders.models.collada.stax.XMLIntArray;
import org.jagatoo.logging.JAGTLog;

public class XMLVertexWeights {
    public int count = -1;
    public ArrayList<XMLInput> inputs = new ArrayList();
    public XMLIntArray vcount = null;
    public XMLIntArray v = null;

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.inputs.size() < 2) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " Not enough input tags (2 required).");
        }
        boolean jointFound = false;
        for (XMLInput in : this.inputs) {
            if (!in.semantic.equals("JOINT")) continue;
            jointFound = true;
            break;
        }
        if (!jointFound) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " At least 1 input with semantic JOINT needed.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("count")) {
                this.count = Integer.parseInt(parser.getAttributeValue(i));
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("input")) {
                        XMLInput input = new XMLInput();
                        input.parse(parser);
                        this.inputs.add(input);
                        break;
                    }
                    if (localName.equals("vcount")) {
                        if (this.vcount != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " too many ", localName, " tags.");
                        }
                        this.vcount = new XMLIntArray();
                        this.vcount.parse(parser, "vcount");
                        break;
                    }
                    if (localName.equals("v")) {
                        if (this.v != null) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " too many ", localName, " tags.");
                        }
                        this.v = new XMLIntArray();
                        this.v.parse(parser, "v");
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("vertex_weights")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

