/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md2;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.openmali.vecmath2.Matrix4f;

public class MD2TagFile {
    private static int MAGIC_NUMBER = 844121162;
    private static int VERSION = 1;
    private static int MAX_TAG_NAME_LENGTH = 64;
    private int version;
    private int numTags;
    private int numFrames;
    private int offsetNames;
    private int offsetMatrices;
    private String[] tagNames;
    private Matrix4f[][] matrices;

    public final int getNumTags() {
        return this.tagNames.length;
    }

    public final String[] getTagNames() {
        return this.tagNames;
    }

    public final Matrix4f[][] getMatrices() {
        return this.matrices;
    }

    private void readHeader(LittleEndianDataInputStream in) throws IOException, IncorrectFormatException, ParsingException {
        int ident = in.readInt();
        if (ident != MAGIC_NUMBER) {
            throw new IncorrectFormatException("This is not an MD2-TAG file!");
        }
        this.version = in.readInt();
        if (this.version != VERSION) {
            throw new IncorrectFormatException("Unsupported MD2-TAG version " + this.version + ". Currently ony version " + VERSION + " is supported.");
        }
        this.numTags = in.readInt();
        this.numFrames = in.readInt();
        this.offsetNames = in.readInt();
        this.offsetMatrices = in.readInt();
        in.readInt();
        in.readInt();
    }

    private String[] readTagNames(LittleEndianDataInputStream in) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD2 TAG names...");
        in.skipBytes(this.offsetNames - in.getPointer());
        String[] tagNames = new String[this.numTags];
        int i = 0;
        while (i != this.numTags) {
            tagNames[i] = in.readCString(MAX_TAG_NAME_LENGTH, true);
            ++i;
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return tagNames;
    }

    private Matrix4f readMatrix(LittleEndianDataInputStream in, boolean convertZup2Yup, float scale) throws IOException {
        Matrix4f m = new Matrix4f();
        int i = 0;
        while (i < 4) {
            float f1 = in.readFloat();
            float f2 = in.readFloat();
            float f3 = in.readFloat();
            m.setColumn(i, f1, f2, f3, i < 3 ? 0.0f : 1.0f);
            ++i;
        }
        if (convertZup2Yup) {
            m.mul(Matrix4f.Z_UP_TO_Y_UP, m);
            m.mul(m, Matrix4f.ROT_PLUS_90_DEG_BY_X_AXIS);
            if (scale != 1.0f) {
                m.m03(m.m03() * scale);
                m.m13(m.m13() * scale);
                m.m23(m.m23() * scale);
            }
        } else if (scale != 1.0f) {
            m.m03(m.m03() * scale);
            m.m13(m.m13() * scale);
            m.m23(m.m23() * scale);
        }
        return m;
    }

    private Matrix4f[][] readMatrices(LittleEndianDataInputStream in, boolean convertZup2Yup, float scale) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD2 TAG matrices...");
        in.skipBytes(this.offsetMatrices - in.getPointer());
        Matrix4f[][] matrices = new Matrix4f[this.numFrames][];
        int f = 0;
        while (f < this.numFrames) {
            matrices[f] = new Matrix4f[this.numTags];
            ++f;
        }
        int t = 0;
        while (t < this.numTags) {
            int f2 = 0;
            while (f2 < this.numFrames) {
                Matrix4f matrix;
                matrices[f2][t] = matrix = this.readMatrix(in, convertZup2Yup, scale);
                ++f2;
            }
            ++t;
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return matrices;
    }

    public MD2TagFile(InputStream in, boolean convertZup2Yup, float scale) throws IOException, IncorrectFormatException, ParsingException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        LittleEndianDataInputStream lein = new LittleEndianDataInputStream(in);
        this.readHeader(lein);
        this.tagNames = this.readTagNames(lein);
        this.matrices = this.readMatrices(lein, convertZup2Yup, scale);
        lein.close();
    }
}

