/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md3;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.md3.MD3Frame;
import org.jagatoo.loaders.models.md3.MD3Header;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.openmali.FastMath;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.VecMathUtils;

public class MD3File {
    private final LittleEndianDataInputStream in;
    private final MD3Header header;
    private MD3Frame[] frames;
    private final HashMap<String, NamedObject> shaderCache = new HashMap();
    private static final GeometryFactory.GeometryType GEOM_TYPE = GeometryFactory.GeometryType.INDEXED_TRIANGLE_ARRAY;
    private static final float COORDINATE_SCALE = 0.015625f;

    static final String fixPath(String path) {
        if (path.indexOf(92) >= 0) {
            path = path.replace('\\', '/');
        }
        if (path.indexOf(32) >= 0) {
            path = path.replace(" ", "%20");
        }
        return path;
    }

    private void readFrames() throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD3 frames...");
        this.in.skipBytes(this.header.frameOffset - this.in.getPointer());
        this.frames = new MD3Frame[this.header.numFrames];
        int i = 0;
        while (i < this.header.numFrames) {
            this.frames[i] = MD3Frame.readFrame(this.in);
            ++i;
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
    }

    private Matrix4f[][] readTags(boolean convertZup2Yup, float scale, SpecialItemsHandler siHandler) throws IOException, IncorrectFormatException, ParsingException {
        if (this.header.numTags == 0) {
            return null;
        }
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD3 tags...");
        this.in.skipBytes(this.header.tagOffset - this.in.getPointer());
        Matrix4f[][] tagFrames = new Matrix4f[this.header.numFrames][];
        Vector3f translation = Vector3f.fromPool();
        Matrix3f rotation = Matrix3f.fromPool();
        Matrix4f tmp = Matrix4f.fromPool();
        tmp.setIdentity();
        int f = 0;
        while (f < this.header.numFrames) {
            tagFrames[f] = new Matrix4f[this.header.numTags];
            int t = 0;
            while (t < this.header.numTags) {
                String name = this.in.readCString(64, true);
                VecMathUtils.readTuple3f((DataInput)this.in, (Tuple3f)translation);
                VecMathUtils.readMatrix3f((DataInput)this.in, (Matrix3f)rotation);
                if (convertZup2Yup) {
                    AxisAngle3f aa = AxisAngle3f.fromPool();
                    aa.set(rotation);
                    aa.set(aa.getX(), aa.getZ(), -aa.getY(), aa.getAngle());
                    rotation.set(aa);
                    AxisAngle3f.toPool((AxisAngle3f)aa);
                }
                Matrix4f transform = new Matrix4f();
                transform.set(rotation);
                if (convertZup2Yup) {
                    tmp.m03(translation.getX() * scale);
                    tmp.m13(translation.getZ() * scale);
                    tmp.m23(-translation.getY() * scale);
                } else {
                    tmp.m03(translation.getX() * scale);
                    tmp.m13(translation.getY() * scale);
                    tmp.m23(translation.getZ() * scale);
                }
                transform.mul(tmp, transform);
                tagFrames[f][t] = transform;
                if (f == 0) {
                    siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.MOUNT_TRANSFORM, name, transform);
                }
                ++t;
            }
            ++f;
        }
        Matrix4f.toPool((Matrix4f)tmp);
        Vector3f.toPool((Vector3f)translation);
        Matrix3f.toPool((Matrix3f)rotation);
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return tagFrames;
    }

    private AbstractTexture loadTexture(String texName, URL baseURL, AppearanceFactory appFactory) {
        int lastSlashPos;
        AbstractTexture texture = appFactory.loadOrGetTexture(texName, baseURL, true, true, true, true, true);
        if (!appFactory.isFallbackTexture(texture)) {
            return texture;
        }
        if (texName.endsWith(".tga")) {
            String texBaseName = texName.substring(0, texName.length() - 4);
            texture = appFactory.loadOrGetTexture(texBaseName, baseURL, true, true, true, true, true);
            if (!appFactory.isFallbackTexture(texture)) {
                return texture;
            }
            texture = appFactory.loadOrGetTexture(String.valueOf(texBaseName) + ".jpg", baseURL, true, true, true, true, true);
            if (!appFactory.isFallbackTexture(texture)) {
                return texture;
            }
        } else {
            texture = appFactory.loadOrGetTexture(String.valueOf(texName) + ".jpg", baseURL, true, true, true, true, true);
            if (!appFactory.isFallbackTexture(texture)) {
                return texture;
            }
        }
        if ((lastSlashPos = texName.lastIndexOf(47)) >= 0) {
            String texBaseName = texName.substring(lastSlashPos + 1);
            texture = appFactory.loadOrGetTexture(texBaseName, baseURL, true, true, true, true, true);
            if (!appFactory.isFallbackTexture(texture)) {
                return texture;
            }
            if (texBaseName.endsWith(".tga")) {
                texture = appFactory.loadOrGetTexture(texBaseName = texBaseName.substring(0, texBaseName.length() - 4), baseURL, true, true, true, true, true);
                if (!appFactory.isFallbackTexture(texture)) {
                    return texture;
                }
                texture = appFactory.loadOrGetTexture(String.valueOf(texBaseName) + ".jpg", baseURL, true, true, true, true, true);
                if (!appFactory.isFallbackTexture(texture)) {
                    return texture;
                }
            } else {
                texture = appFactory.loadOrGetTexture(String.valueOf(texBaseName) + ".jpg", baseURL, true, true, true, true, true);
                if (!appFactory.isFallbackTexture(texture)) {
                    return texture;
                }
            }
        }
        JAGTLog.printlnEx("Couldn't find texture resource \"", texName, "\"!");
        return texture;
    }

    private NamedObject[] readShaders(int shadersOffset, int numShaders, URL baseURL, AppearanceFactory appFactory) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD3 shaders...");
        this.in.skipBytes(this.header.surfaceOffset + shadersOffset - this.in.getPointer());
        NamedObject[] shaders = new NamedObject[numShaders];
        int i = 0;
        while (i < numShaders) {
            String shaderName = MD3File.fixPath(this.in.readCString(64, true));
            int shaderIndex = this.in.readInt();
            NamedObject shader = this.shaderCache.get(shaderName);
            if (shader == null) {
                AbstractTexture texture = shaderName == null || shaderName.length() == 0 ? appFactory.getFallbackTexture() : this.loadTexture(shaderName, baseURL, appFactory);
                shader = appFactory.createAppearance(shaderName, 0);
                appFactory.applyTexture(texture, 0, shader);
                this.shaderCache.put(shaderName, shader);
            }
            shaders[shaderIndex] = shader;
            ++i;
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return shaders;
    }

    private void readTriangles(int trianglesOffset, int numTriangles, GeometryFactory geomFactory, NamedObject geometry) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD3 triangles...");
        this.in.skipBytes(this.header.surfaceOffset + trianglesOffset - this.in.getPointer());
        int[] buffer = new int[3];
        int i = 0;
        while (i < numTriangles) {
            buffer[0] = this.in.readInt();
            buffer[1] = this.in.readInt();
            buffer[2] = this.in.readInt();
            geomFactory.setIndex(geometry, GEOM_TYPE, i * 3, buffer, 0, 3);
            ++i;
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
    }

    private void readTextureCoordinates(int textureCoordsOffset, int numVertices, GeometryFactory geomFactory, NamedObject geometry) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD3 texture-coordinates...");
        this.in.skipBytes(this.header.surfaceOffset + textureCoordsOffset - this.in.getPointer());
        int i = 0;
        while (i < numVertices) {
            float s = this.in.readFloat();
            float t = 1.0f - this.in.readFloat();
            geomFactory.setTexCoord(geometry, GEOM_TYPE, 0, i, s, t);
            ++i;
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
    }

    private Object[] readCoordinatesAndNormals(int numFrames, int coordNormalOffset, int numVertices, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NamedObject geometry, AnimationFactory animFactory) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD3 vertex-coordinates and -normals (for all frames)...");
        this.in.skipBytes(this.header.surfaceOffset + coordNormalOffset - this.in.getPointer());
        Object[] keyFrames = null;
        Point3f coord = Point3f.fromPool();
        Vector3f normal = Vector3f.fromPool();
        int f = 0;
        while (f < numFrames) {
            float[] keyFrameCoords = null;
            float[] keyFrameNormals = null;
            if (numFrames > 1) {
                keyFrameCoords = new float[numVertices * 3];
                keyFrameNormals = new float[numVertices * 3];
            }
            int i = 0;
            while (i < numVertices) {
                float x = (float)this.in.readShort() * scale;
                float y = (float)this.in.readShort() * scale;
                float z = (float)this.in.readShort() * scale;
                if (convertZup2Yup) {
                    coord.set(x, y, z);
                    x = coord.getX();
                    y = coord.getZ();
                    z = -coord.getY();
                }
                if (f == 0) {
                    geomFactory.setCoordinate(geometry, GEOM_TYPE, i, x, y, z);
                }
                if (numFrames > 1) {
                    keyFrameCoords[i * 3 + 0] = x;
                    keyFrameCoords[i * 3 + 1] = y;
                    keyFrameCoords[i * 3 + 2] = z;
                }
                byte azimuth = this.in.readByte();
                byte zenith = this.in.readByte();
                float lat = (float)zenith * ((float)Math.PI * 2) / 255.0f;
                float lng = (float)azimuth * ((float)Math.PI * 2) / 255.0f;
                x = FastMath.cos((float)lat) * FastMath.sin((float)lng);
                y = FastMath.sin((float)lat) * FastMath.sin((float)lng);
                z = FastMath.cos((float)lng);
                if (convertZup2Yup) {
                    normal.set(x, y, z);
                    normal.add((TupleNf)coord);
                    Matrix3f.Z_UP_TO_Y_UP.transform((Tuple3f)normal);
                    normal.sub(coord.getX(), coord.getZ(), -coord.getY());
                    normal.normalize();
                    x = normal.getX();
                    y = normal.getY();
                    z = normal.getZ();
                }
                if (f == 0) {
                    geomFactory.setNormal(geometry, GEOM_TYPE, i, x, y, z);
                }
                if (numFrames > 1) {
                    keyFrameNormals[i * 3 + 0] = x;
                    keyFrameNormals[i * 3 + 1] = y;
                    keyFrameNormals[i * 3 + 2] = z;
                }
                ++i;
            }
            if (numFrames > 1) {
                Object keyFrame = animFactory.createMeshDeformationKeyFrame(keyFrameCoords, keyFrameNormals);
                if (keyFrames == null) {
                    keyFrames = (Object[])Array.newInstance(keyFrame.getClass(), numFrames);
                }
                keyFrames[f] = animFactory.createMeshDeformationKeyFrame(keyFrameCoords, keyFrameNormals);
            }
            ++f;
        }
        Vector3f.toPool((Vector3f)normal);
        Point3f.toPool((Point3f)coord);
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return keyFrames;
    }

    private void readSurfaces(URL baseURL, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, AnimationFactory animFactory, Matrix4f[][] frameTags, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD3 surfaces...");
        this.in.skipBytes(this.header.surfaceOffset - this.in.getPointer());
        ArrayList<Object> controllersList = new ArrayList<Object>(this.header.numSurfaces);
        int s = 0;
        while (s < this.header.numSurfaces) {
            int magic = this.in.readInt();
            if (magic != 860898377) {
                throw new IncorrectFormatException("Invalid magic number found at MD3 surfaces block " + s + ". (" + magic + " != " + 860898377 + ")");
            }
            String surfaceName = this.in.readCString(64, true);
            this.in.readInt();
            int numFrames = this.in.readInt();
            int numShaders = this.in.readInt();
            int numVertices = this.in.readInt();
            int numTriangles = this.in.readInt();
            int trianglesOffset = this.in.readInt();
            int shadersOffset = this.in.readInt();
            int textureCoordsOffset = this.in.readInt();
            int coordNormalOffset = this.in.readInt();
            this.in.readInt();
            NamedObject geometry = geomFactory.createInterleavedGeometry(surfaceName, GEOM_TYPE, 3, numVertices, numTriangles * 3, null, 11, false, new int[]{2}, null);
            NamedObject[] shaders = this.readShaders(shadersOffset, numShaders, baseURL, appFactory);
            this.readTriangles(trianglesOffset, numTriangles, geomFactory, geometry);
            this.readTextureCoordinates(textureCoordsOffset, numVertices, geomFactory, geometry);
            Object[] keyFrames = this.readCoordinatesAndNormals(numFrames, coordNormalOffset, numVertices, geomFactory, convertZup2Yup, scale, geometry, animFactory);
            NamedObject shape = nodeFactory.createShape(surfaceName, geometry, shaders.length > 0 ? shaders[0] : null, BoundsType.SPHERE);
            nodeFactory.addNodeToGroup(shape, rootGroup);
            siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SHAPE, shape.getName(), shape);
            if (numFrames > 1) {
                controllersList.add(animFactory.createMeshDeformationKeyFrameController(keyFrames, shape));
            }
            ++s;
        }
        if (controllersList.size() > 0) {
            Object[] animControllers = (Object[])Array.newInstance(controllersList.get(0).getClass(), controllersList.size());
            animControllers = controllersList.toArray(animControllers);
            Object animation = animFactory.createAnimation("default", this.header.numFrames, 9.0f, animControllers, frameTags);
            siHandler.addAnimation(animation);
        }
        JAGTLog.debug("done loading ", this.header.numSurfaces, " surfaces. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
    }

    private MD3File(InputStream in, URL baseURL, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        this.in = new LittleEndianDataInputStream(in);
        try {
            this.header = MD3Header.readHeader(this.in);
            this.readFrames();
            Matrix4f[][] frameTags = this.readTags(convertZup2Yup, scale, siHandler);
            this.readSurfaces(baseURL, appFactory, geomFactory, convertZup2Yup, scale * 0.015625f, nodeFactory, animFactory, frameTags, siHandler, rootGroup);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static final void load(InputStream in, URL baseURL, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        new MD3File(in, baseURL, appFactory, geomFactory, convertZup2Yup, scale, nodeFactory, animFactory, siHandler, rootGroup);
    }
}

