/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md5;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.jagatoo.util.strings.SimpleStringTokenizer;
import org.jagatoo.util.strings.StringUtils;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MD5AnimationReader {
    private static Object calcFrame(float[] baseFrame, ArrayList<String> boneDefs, float[] values, AnimationFactory animFactory, boolean convertZup2Yup, float scale) {
        SimpleStringTokenizer st = new SimpleStringTokenizer("");
        int numBones = boneDefs.size();
        Vector3f[] boneTrs = new Vector3f[numBones];
        Quaternion4f[] boneRots = new Quaternion4f[numBones];
        NamedObject[] bones = null;
        int i = 0;
        while (i < numBones) {
            Vector3f translation = new Vector3f(baseFrame[i * 6 + 0], baseFrame[i * 6 + 1], baseFrame[i * 6 + 2]);
            Quaternion4f rotation = new Quaternion4f(baseFrame[i * 6 + 3], baseFrame[i * 6 + 4], baseFrame[i * 6 + 5], 0.0f);
            st.setString(boneDefs.get(i));
            String name = StringUtils.unquoteString(st.nextToken());
            int parent = Integer.parseInt(st.nextToken());
            int flags = Integer.parseInt(st.nextToken());
            int startIndex = Integer.parseInt(st.nextToken());
            int j = 0;
            if ((flags & 1) != 0) {
                translation.setX(values[startIndex + j]);
                ++j;
            }
            if ((flags & 2) != 0) {
                translation.setY(values[startIndex + j]);
                ++j;
            }
            if ((flags & 4) != 0) {
                translation.setZ(values[startIndex + j]);
                ++j;
            }
            if ((flags & 8) != 0) {
                rotation.setA(values[startIndex + j]);
                ++j;
            }
            if ((flags & 0x10) != 0) {
                rotation.setB(values[startIndex + j]);
                ++j;
            }
            if ((flags & 0x20) != 0) {
                rotation.setC(values[startIndex + j]);
                ++j;
            }
            rotation.computeD();
            boneTrs[i] = translation;
            boneRots[i] = rotation;
            NamedObject parentBone = null;
            if (parent == -1) {
                if (convertZup2Yup) {
                    rotation.mul(Quaternion4f.Z_UP_TO_Y_UP, rotation);
                }
            } else {
                if (bones == null) {
                    throw new ParsingException("Can't find the parent bone by id " + parent);
                }
                parentBone = bones[parent];
                Point3f rpos = (Point3f)boneRots[parent].transform((Tuple3f)translation, (Tuple3f)new Point3f());
                translation.set(rpos.getX() + boneTrs[parent].getX(), rpos.getY() + boneTrs[parent].getY(), rpos.getZ() + boneTrs[parent].getZ());
                rotation.mul(boneRots[parent], rotation);
                rotation.normalize();
            }
            NamedObject bone = animFactory.createBone(parentBone, name, translation, rotation, null);
            if (bones == null) {
                bones = (NamedObject[])Array.newInstance(bone.getClass(), numBones);
            }
            bones[i] = bone;
            ++i;
        }
        return animFactory.createBoneAnimationKeyFrame(bones);
    }

    public static void load(InputStream in, String filename, URL baseURL, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, NamedObject[] shapes, Object[][][] boneWeights, AnimationFactory animFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        String line;
        float[] baseFrame = null;
        float frameRate = 25.0f;
        int numAnimatedComponents = 0;
        ArrayList<String> boneDefs = null;
        ArrayList<float[]> bounds = null;
        ArrayList<Object> frames = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        SimpleStringTokenizer st = new SimpleStringTokenizer("");
        block0: while ((line = br.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            if (line.startsWith("MD5Version")) {
                int version = Integer.parseInt(line.substring(11), 10);
                if (version == 10) continue;
                br.close();
                throw new IncorrectFormatException("MD5 version " + version + " is not supported. Expected 10.");
            }
            if (line.startsWith("commandline")) continue;
            if (line.startsWith("numFrames")) {
                int numFrames = Integer.parseInt(line.substring(10));
                frames = new ArrayList<Object>(numFrames);
                bounds = new ArrayList<float[]>(numFrames);
                continue;
            }
            if (line.startsWith("numJoints")) {
                int numJoints = Integer.parseInt(line.substring(10));
                boneDefs = new ArrayList<String>(numJoints);
                continue;
            }
            if (line.startsWith("frameRate")) {
                frameRate = Float.parseFloat(line.substring(10));
                continue;
            }
            if (line.startsWith("numAnimatedComponents")) {
                numAnimatedComponents = Integer.parseInt(line.substring(22));
                continue;
            }
            if (line.startsWith("hierarchy")) {
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("")) continue;
                    if (line.equals("}")) continue block0;
                    boneDefs.add(line);
                }
                continue;
            }
            if (line.startsWith("bounds")) {
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("")) continue;
                    if (line.equals("}")) continue block0;
                    float[] bound = new float[6];
                    st.setString(line);
                    st.skipToken();
                    bound[0] = Float.parseFloat(st.nextToken());
                    bound[1] = Float.parseFloat(st.nextToken());
                    bound[2] = Float.parseFloat(st.nextToken());
                    st.skipToken();
                    st.skipToken();
                    bound[3] = Float.parseFloat(st.nextToken());
                    bound[4] = Float.parseFloat(st.nextToken());
                    bound[5] = Float.parseFloat(st.nextToken());
                    st.skipToken();
                    bounds.add(bound);
                }
                continue;
            }
            if (line.startsWith("baseframe")) {
                baseFrame = new float[numAnimatedComponents];
                int i = 0;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("")) continue;
                    if (line.equals("}")) continue block0;
                    st.setString(line);
                    st.skipToken();
                    baseFrame[i * 6 + 0] = Float.parseFloat(st.nextToken());
                    baseFrame[i * 6 + 1] = Float.parseFloat(st.nextToken());
                    baseFrame[i * 6 + 2] = Float.parseFloat(st.nextToken());
                    st.skipToken();
                    st.skipToken();
                    baseFrame[i * 6 + 3] = Float.parseFloat(st.nextToken());
                    baseFrame[i * 6 + 4] = Float.parseFloat(st.nextToken());
                    baseFrame[i * 6 + 5] = Float.parseFloat(st.nextToken());
                    ++i;
                }
                continue;
            }
            if (!line.startsWith("frame")) continue;
            st.setString(line);
            st.skipToken();
            st.skipToken();
            float[] frameValues = new float[numAnimatedComponents];
            int k = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                if (line.equals("}")) break;
                st.setString(line);
                while (st.hasMoreTokens()) {
                    frameValues[k++] = Float.parseFloat(st.nextToken());
                }
            }
            frames.add(MD5AnimationReader.calcFrame(baseFrame, boneDefs, frameValues, animFactory, convertZup2Yup, scale));
        }
        br.close();
        Object[] keyFrames = (Object[])Array.newInstance(frames.get(0).getClass(), frames.size());
        keyFrames = frames.toArray(keyFrames);
        Object[] controllers = null;
        int i = 0;
        while (i < shapes.length) {
            NamedObject shape = shapes[i];
            Object controller = animFactory.createBoneAnimationKeyFrameController(keyFrames, boneWeights[i], shape);
            if (controllers == null) {
                controllers = (Object[])Array.newInstance(controller.getClass(), shapes.length);
            }
            controllers[i] = controller;
            ++i;
        }
        Object animation = animFactory.createAnimation(filename, keyFrames.length, frameRate, controllers, null);
        siHandler.addAnimation(animation);
    }
}

