/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ms3d;

import java.io.IOException;
import org.jagatoo.loaders.models.ms3d.MS3DKeyFrame;
import org.jagatoo.loaders.models.ms3d.utils.BinaryUtils;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;

public class MS3DJoint {
    public String name;
    public String parent;
    public Point3f rotation;
    public Point3f position;
    public int numRotFrames;
    public int numTransFrames;
    public MS3DKeyFrame[] rotKeyFrames;
    public MS3DKeyFrame[] transKeyFrames;
    public int parentIndex = -1;
    public Matrix4f matLocal = new Matrix4f();
    public Matrix4f matAbs = new Matrix4f();
    public Matrix4f matFinal = new Matrix4f();
    public int curRotFrame = 0;
    public int curTransFrame = 0;

    public MS3DJoint(LittleEndianDataInputStream in) throws IOException {
        in.readByte();
        this.name = BinaryUtils.readString(in, 32);
        this.parent = BinaryUtils.readString(in, 32);
        this.rotation = BinaryUtils.readPoint3f(in);
        this.position = BinaryUtils.readPoint3f(in);
        this.numRotFrames = in.readUnsignedShort();
        this.numTransFrames = in.readUnsignedShort();
        this.rotKeyFrames = new MS3DKeyFrame[this.numRotFrames];
        int i = 0;
        while (i < this.rotKeyFrames.length) {
            this.rotKeyFrames[i] = new MS3DKeyFrame(in);
            ++i;
        }
        this.transKeyFrames = new MS3DKeyFrame[this.numTransFrames];
        i = 0;
        while (i < this.transKeyFrames.length) {
            this.transKeyFrames[i] = new MS3DKeyFrame(in);
            ++i;
        }
    }

    public int selectCurrentTransFrame(float currentTime) {
        this.curTransFrame = this.searchNextFrame(this.transKeyFrames, currentTime);
        return this.curTransFrame;
    }

    public int selectCurrentRotFrame(float currentTime) {
        this.curRotFrame = this.searchNextFrame(this.rotKeyFrames, currentTime);
        return this.curRotFrame;
    }

    private int searchNextFrame(MS3DKeyFrame[] frames, float currentTime) {
        int frame = 0;
        while (frame < frames.length && frames[frame].time < currentTime) {
            ++frame;
        }
        return frame;
    }

    public boolean hasKeyFrames() {
        return this.numRotFrames != 0 || this.numTransFrames != 0;
    }
}

