/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ms3d;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.jagatoo.loaders.models.ms3d.MS3DJoint;
import org.jagatoo.loaders.models.ms3d.MS3DKeyFrame;
import org.jagatoo.loaders.models.ms3d.MS3DMaterial;
import org.jagatoo.loaders.models.ms3d.MS3DMesh;
import org.jagatoo.loaders.models.ms3d.MS3DTriangle;
import org.jagatoo.loaders.models.ms3d.MS3DVertex;
import org.jagatoo.loaders.models.ms3d.utils.RotationUtils;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.util.Interpolation;

public class MS3DPrototypeModel {
    private static final String STR_HEADER_NAME = "MS3D000000";
    private static final byte[] HEADER_NAME = "MS3D000000".getBytes();
    private int numVerts;
    private int numTriangles;
    private int numMeshes;
    private int numMaterials;
    private int numJoints;
    private MS3DVertex[] vertices;
    private MS3DTriangle[] triangles;
    private MS3DMesh[] meshes;
    private MS3DMaterial[] materials;
    private MS3DJoint[] joints;
    private Point3f pointAux = new Point3f();
    private float lastTime = -1.0f;
    private float startTime = -1.0f;
    private Point3f speed = new Point3f();

    public MS3DPrototypeModel(BufferedInputStream bin) throws IOException {
        DataInputStream in = new DataInputStream(bin);
        this.readFile(in);
        in.close();
    }

    private void readFile(DataInputStream din) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(din);
        byte[] auxArray = new byte[10];
        in.read(auxArray, 0, 10);
        if (!this.compareHeaderName(auxArray)) {
            throw new RuntimeException("Header name incorrect");
        }
        int version = in.readInt();
        if (version != 3 && version != 4) {
            throw new RuntimeException("Version incorrect");
        }
        this.numVerts = in.readUnsignedShort();
        this.vertices = new MS3DVertex[this.numVerts];
        int i = 0;
        while (i < this.vertices.length) {
            this.vertices[i] = new MS3DVertex(in);
            ++i;
        }
        this.numTriangles = in.readUnsignedShort();
        this.triangles = new MS3DTriangle[this.numTriangles];
        i = 0;
        while (i < this.triangles.length) {
            this.triangles[i] = new MS3DTriangle(in);
            ++i;
        }
        this.numMeshes = in.readUnsignedShort();
        this.meshes = new MS3DMesh[this.numMeshes];
        i = 0;
        while (i < this.meshes.length) {
            this.meshes[i] = new MS3DMesh(in);
            ++i;
        }
        this.numMaterials = in.readUnsignedShort();
        this.materials = new MS3DMaterial[this.numMaterials];
        i = 0;
        while (i < this.materials.length) {
            this.materials[i] = new MS3DMaterial(in);
            ++i;
        }
        auxArray = new byte[12];
        in.read(auxArray, 0, auxArray.length);
        this.numJoints = in.readUnsignedShort();
        this.joints = new MS3DJoint[this.numJoints];
        i = 0;
        while (i < this.joints.length) {
            this.joints[i] = new MS3DJoint(in);
            ++i;
        }
        this.setParentForJoints();
        this.setupJoints();
    }

    private void setupJoints() {
        MS3DJoint joint;
        int i = 0;
        while (i < this.joints.length) {
            joint = this.joints[i];
            joint.matLocal.setRotation((Tuple3f)joint.rotation);
            joint.matLocal.setTranslation((Tuple3f)joint.position);
            if (joint.parentIndex != -1) {
                joint.matAbs.set(this.joints[joint.parentIndex].matAbs);
                joint.matAbs.mul(joint.matLocal);
            } else {
                joint.matAbs.set(joint.matLocal);
            }
            joint.matFinal.set(joint.matAbs);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.vertices.length) {
            MS3DVertex vertex = this.vertices[i2];
            if (vertex.bone != -1) {
                Matrix4f mat = this.joints[vertex.bone].matFinal;
                this.pointAux.set((TupleNf)vertex.vert);
                this.pointAux.negate();
                mat.setTranslation((Tuple3f)this.pointAux);
                mat.setInvRotation((Tuple3f)this.pointAux);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.triangles.length) {
            MS3DTriangle triangle = this.triangles[i3];
            int j = 0;
            while (j < 3) {
                MS3DVertex vertex = this.vertices[triangle.vertIndices[j]];
                if (vertex.bone != -1) {
                    joint = this.joints[vertex.bone];
                    joint.matFinal.setInvRotation((Tuple3f)this.pointAux);
                }
                ++j;
            }
            ++i3;
        }
    }

    private void setParentForJoints() {
        int i = 0;
        while (i < this.joints.length) {
            if (this.joints[i].parent != null) {
                int j = 0;
                while (j < this.joints.length) {
                    if (this.joints[j].name.equals(this.joints[i].parent)) {
                        this.joints[i].parentIndex = j;
                    }
                    ++j;
                }
            } else {
                this.joints[i].parentIndex = -1;
            }
            ++i;
        }
    }

    private boolean compareHeaderName(byte[] headerName) {
        int i = 0;
        while (i < headerName.length) {
            if (headerName[i] != HEADER_NAME[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void initAnimation(float currentTime) {
        this.lastTime = this.startTime = currentTime;
    }

    public void animate(float currentTime) {
        float deltaT = currentTime - this.lastTime;
        this.lastTime = currentTime;
        int i = 0;
        while (i < this.joints.length) {
            MS3DJoint joint = this.joints[i];
            if (!joint.hasKeyFrames()) {
                joint.matFinal.set(joint.matAbs);
            } else {
                Point3f translation = new Point3f();
                int frame = joint.selectCurrentTransFrame(currentTime - this.startTime);
                if (frame == 0) {
                    translation.set((TupleNf)joint.transKeyFrames[frame].param);
                } else if (frame == joint.numTransFrames) {
                    translation.set((TupleNf)joint.transKeyFrames[frame - 1].param);
                } else {
                    MS3DKeyFrame curFrame = joint.transKeyFrames[frame];
                    MS3DKeyFrame prevFrame = joint.transKeyFrames[frame - 1];
                    float timeDist = curFrame.time - prevFrame.time;
                    this.speed.set((TupleNf)curFrame.param);
                    this.speed.sub((TupleNf)prevFrame.param);
                    this.speed.scale(1.0f / timeDist);
                    this.speed.scale(deltaT);
                    translation.set((TupleNf)curFrame.param);
                    translation.add((TupleNf)this.speed);
                }
                Matrix4f matTmp = new Matrix4f();
                frame = joint.selectCurrentRotFrame(currentTime);
                if (frame == 0) {
                    matTmp.setRotation((Tuple3f)joint.rotKeyFrames[frame].param);
                } else if (frame == joint.numTransFrames) {
                    matTmp.setRotation((Tuple3f)joint.rotKeyFrames[frame - 1].param);
                } else {
                    MS3DKeyFrame curFrame = joint.rotKeyFrames[frame];
                    MS3DKeyFrame prevFrame = joint.rotKeyFrames[frame - 1];
                    float timeDist = curFrame.time - prevFrame.time;
                    Quaternion4f quatCur = RotationUtils.toQuaternion((Tuple3f)curFrame.param);
                    Quaternion4f quatPrev = RotationUtils.toQuaternion((Tuple3f)prevFrame.param);
                    Quaternion4f quatSpeed = new Quaternion4f();
                    Interpolation.nlerp((Quaternion4f)quatCur, (Quaternion4f)quatPrev, (float)timeDist, (Quaternion4f)quatSpeed);
                    quatSpeed.scale(1.0f / timeDist);
                    matTmp.set(quatSpeed);
                }
                matTmp.setTranslation((Tuple3f)translation);
                Matrix4f matFinal = new Matrix4f(joint.matLocal);
                matFinal.mul(matTmp);
                if (joint.parentIndex == -1) {
                    joint.matFinal.set(matFinal);
                } else {
                    joint.matFinal.set(this.joints[joint.parentIndex].matFinal);
                    joint.matFinal.mul(matFinal);
                }
            }
            ++i;
        }
    }
}

