/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ms3d;

import java.io.IOException;
import org.jagatoo.loaders.models.ms3d.utils.BinaryUtils;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.openmali.vecmath2.Point3f;

public class MS3DTriangle {
    public int[] vertIndices = new int[3];
    public Point3f[] normals = new Point3f[3];
    public float[][] texCoords = new float[2][3];
    public int smoothing;
    public int group;

    public MS3DTriangle(LittleEndianDataInputStream in) throws IOException {
        in.readUnsignedShort();
        int i = 0;
        while (i < this.vertIndices.length) {
            this.vertIndices[i] = in.readUnsignedShort();
            ++i;
        }
        i = 0;
        while (i < this.normals.length) {
            this.normals[i] = BinaryUtils.readPoint3f(in);
            ++i;
        }
        i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 3) {
                this.texCoords[i][j] = in.readFloat();
                ++j;
            }
            ++i;
        }
        this.smoothing = in.readUnsignedByte();
        this.group = in.readUnsignedByte();
    }
}

