/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ms3d.utils;

import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.MatrixUtils;

public class RotationUtils {
    public static Quaternion4f toQuaternion(float rotX, float rotY, float rotZ) {
        float x = FastMath.toRad((float)rotX);
        float y = FastMath.toRad((float)rotY);
        float z = FastMath.toRad((float)rotZ);
        Matrix3f matrix = MatrixUtils.eulerToMatrix3f((float)x, (float)y, (float)z);
        Quaternion4f quat = new Quaternion4f();
        quat.set(matrix);
        quat.normalize();
        return quat;
    }

    public static Quaternion4f toQuaternion(Tuple3f tuple) {
        return RotationUtils.toQuaternion(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static Tuple3f toEuler(Quaternion4f quaternion) {
        Matrix3f matrix = new Matrix3f();
        matrix.set(quaternion);
        Tuple3f euler = MatrixUtils.matrixToEuler((Matrix3f)matrix);
        euler.setX(FastMath.toDeg((float)euler.getX()));
        euler.setY(FastMath.toDeg((float)euler.getY()));
        euler.setZ(FastMath.toDeg((float)euler.getZ()));
        return euler;
    }
}

