/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.obj;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.obj.OBJConverter;
import org.jagatoo.loaders.models.obj.OBJGroup;
import org.jagatoo.loaders.models.obj.OBJMaterial;
import org.jagatoo.loaders.models.obj.OBJModelPrototype;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OBJPrototypeLoader {
    protected static Boolean debug = false;

    private static float[] parseVector(String line) {
        StringTokenizer tokens = new StringTokenizer(line);
        tokens.nextToken();
        float[] vector = new float[]{Float.parseFloat(tokens.nextToken()), Float.parseFloat(tokens.nextToken()), Float.parseFloat(tokens.nextToken())};
        return vector;
    }

    private static float[] parseTexCoord(String line) {
        StringTokenizer tokens = new StringTokenizer(line);
        tokens.nextToken();
        float[] texCoord = new float[]{Float.parseFloat(tokens.nextToken()), Float.parseFloat(tokens.nextToken())};
        return texCoord;
    }

    private static float[] parseColor(String token) {
        StringTokenizer tokens = new StringTokenizer(token);
        float[] color = new float[]{Float.parseFloat(tokens.nextToken()), Float.parseFloat(tokens.nextToken()), Float.parseFloat(tokens.nextToken())};
        return color;
    }

    private static List<OBJMaterial> parseMatLib(URL baseURL, String name) throws IOException {
        ArrayList<OBJMaterial> matList = new ArrayList<OBJMaterial>(1);
        OBJMaterial mat = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new URL(baseURL, name).openStream()));
            }
            catch (FileNotFoundException f) {
                try {
                    System.out.println("Base URL = " + baseURL);
                    System.out.println("Resource name = " + name);
                    bufferedReader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(name)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            while ((line = bufferedReader.readLine()) != null) {
                float[] color;
                int i = 0;
                while (i < line.length()) {
                    if (!Character.isWhitespace(line.charAt(i))) break;
                    ++i;
                }
                line = line.substring(i);
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                if (line.startsWith("newmtl")) {
                    String matName = line.substring(line.indexOf(" ") + 1);
                    mat = new OBJMaterial(matName);
                    matList.add(mat);
                    continue;
                }
                if (line.startsWith("Tf")) {
                    color = OBJPrototypeLoader.parseColor(line.substring(line.indexOf(" ") + 1));
                    mat.setDiffuseColor(color);
                    mat.setAmbientColor(color);
                    continue;
                }
                if (line.startsWith("Ka")) {
                    color = OBJPrototypeLoader.parseColor(line.substring(line.indexOf(" ") + 1));
                    mat.setAmbientColor(color);
                    continue;
                }
                if (line.startsWith("Kd")) {
                    color = OBJPrototypeLoader.parseColor(line.substring(line.indexOf(" ") + 1));
                    mat.setColor(color);
                    mat.setDiffuseColor(color);
                    continue;
                }
                if (line.startsWith("Ks")) {
                    color = OBJPrototypeLoader.parseColor(line.substring(line.indexOf(" ") + 1));
                    mat.setSpecularColor(color);
                    continue;
                }
                if (line.startsWith("Ns")) {
                    mat.setShininess(Float.parseFloat(line.substring(line.indexOf(" ") + 1)));
                    continue;
                }
                if (line.startsWith("map_Kd")) {
                    String texName = line.substring(line.indexOf(" ") + 1);
                    mat.setTextureName(texName);
                    continue;
                }
                if (debug == null || !debug.booleanValue()) continue;
                System.err.println(String.valueOf(OBJPrototypeLoader.class.getName()) + ":  ignoring unknown material tag:  \"" + line + "\"");
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return matList;
    }

    public static OBJModelPrototype load(InputStream in, URL baseURL, float[] geomOffset) throws IOException {
        if (geomOffset != null && geomOffset.length != 3) {
            throw new IllegalArgumentException("geomOffset must be either null or length 3.");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        HashMap<String, OBJMaterial> matMap = new HashMap<String, OBJMaterial>();
        ArrayList<float[]> verts = new ArrayList<float[]>();
        ArrayList<float[]> normals = new ArrayList<float[]>();
        ArrayList<float[]> texs = new ArrayList<float[]>();
        OBJGroup topGroup = OBJGroup.createTopGroup(verts, normals, texs);
        try {
            OBJMaterial currentMat = null;
            OBJGroup currentGroup = topGroup;
            String line = null;
            while ((line = br.readLine()) != null) {
                OBJGroup g;
                String name;
                if (line.startsWith("#") || line.length() == 0) continue;
                if (line.startsWith("vn")) {
                    normals.add(OBJPrototypeLoader.parseVector(line));
                    continue;
                }
                if (line.startsWith("vt")) {
                    texs.add(OBJPrototypeLoader.parseTexCoord(line));
                    continue;
                }
                if (line.startsWith("v")) {
                    float[] vert = OBJPrototypeLoader.parseVector(line);
                    if (geomOffset != null) {
                        vert[0] = vert[0] + geomOffset[0];
                        vert[1] = vert[1] + geomOffset[1];
                        vert[2] = vert[2] + geomOffset[2];
                    }
                    verts.add(vert);
                    continue;
                }
                if (line.startsWith("f")) {
                    currentGroup.add(line, currentMat);
                    continue;
                }
                if (line.startsWith("g")) {
                    name = line.trim().length() >= 3 ? line.substring(2) : null;
                    g = new OBJGroup(name, verts, normals, texs);
                    topGroup.addChild(g);
                    currentGroup = g;
                    continue;
                }
                if (line.startsWith("o")) {
                    name = line.trim().length() >= 3 ? line.substring(2) : null;
                    g = new OBJGroup(name, verts, normals, texs);
                    topGroup.addChild(g);
                    currentGroup = g;
                    continue;
                }
                if (line.startsWith("mtllib")) {
                    StringTokenizer tokens = new StringTokenizer(line);
                    tokens.nextToken();
                    String name2 = tokens.nextToken();
                    List<OBJMaterial> matList = OBJPrototypeLoader.parseMatLib(baseURL, name2);
                    for (OBJMaterial mat : matList) {
                        if (mat == null) continue;
                        matMap.put(mat.getName(), mat);
                    }
                    continue;
                }
                if (line.startsWith("usemtl")) {
                    name = line.substring(line.indexOf(" ") + 1);
                    currentMat = matMap.get(name);
                    continue;
                }
                if (line.startsWith("s")) {
                    if (debug == null || !debug.booleanValue()) continue;
                    System.err.println(String.valueOf(OBJPrototypeLoader.class.getName()) + ":  smoothing groups not currently supported:  \"" + line + "\"");
                    continue;
                }
                if (debug == null || !debug.booleanValue()) continue;
                System.err.println(String.valueOf(OBJPrototypeLoader.class.getName()) + ":  ignoring unknown OBJ tag:  \"" + line + "\"");
            }
        }
        finally {
            br.close();
        }
        return new OBJModelPrototype(matMap, topGroup);
    }

    public static OBJModelPrototype load(InputStream in, URL baseURL) throws IOException {
        return OBJPrototypeLoader.load(in, baseURL, null);
    }

    public static void load(InputStream in, URL baseURL, AppearanceFactory appFactory, String skin, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        OBJModelPrototype prototype = OBJPrototypeLoader.load(in, baseURL);
        OBJConverter.convert(prototype, baseURL, appFactory, skin, geomFactory, convertZup2Yup, scale, nodeFactory, siHandler, rootGroup);
    }

    private OBJPrototypeLoader() {
    }
}

