/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.chunks.TDSChunkType;
import org.jagatoo.loaders.models.tds.chunks.processors.ChunkProcessor;
import org.jagatoo.loaders.models.tds.internal.ModelContext;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.openmali.vecmath2.Matrix3f;

public class TDSFile {
    private final DataInputStream din;
    private final URL baseURL;
    private final ModelContext context = new ModelContext();
    private final AppearanceFactory appFactory;
    private final GeometryFactory geomFactory;
    private final NodeFactory nodeFactory;
    private final AnimationFactory animFactory;
    private final SpecialItemsHandler siHandler;
    private final boolean convertZup2Yup;

    public final URL getBaseURL() {
        return this.baseURL;
    }

    public final boolean convertZup2Yup() {
        return this.convertZup2Yup;
    }

    public final ModelContext getContext() {
        return this.context;
    }

    public final byte readByte() throws IOException {
        return this.din.readByte();
    }

    public final short readUnsignedByte() throws IOException {
        return (short)this.din.readUnsignedByte();
    }

    public final int readUnsignedShort() throws IOException {
        int num = this.din.readUnsignedShort();
        return num << 8 & 0xFF00 | num >> 8 & 0xFF;
    }

    public final int readInt() throws IOException {
        int num = this.din.readInt();
        return num << 24 & 0xFF000000 | num << 8 & 0xFF0000 | num >> 8 & 0xFF00 | num >> 24 & 0xFF;
    }

    public final int readUnsignedInt() throws IOException {
        long uint = this.readInt() & 0xFFFFFFFF;
        return (int)uint;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void skipBytes(int bytesToSkip) throws IOException {
        while (bytesToSkip > 0) {
            bytesToSkip -= this.din.skipBytes(bytesToSkip);
        }
    }

    public final void skipChunk(int length) throws IOException {
        this.skipBytes(length - 6);
    }

    public final boolean hiddenObject(String name) {
        return name.charAt(0) == '$';
    }

    public final float readPercentage(boolean readChunkID, int[] chunkID) throws IOException {
        int tag = readChunkID ? this.readUnsignedShort() : chunkID[0];
        if (tag == TDSChunkType.INT_PERCENTAGE.getID()) {
            this.readInt();
            return (float)this.readUnsignedShort() / 100.0f;
        }
        if (tag == TDSChunkType.FLOAT_PERCENTAGE.getID()) {
            this.readInt();
            return this.readFloat();
        }
        String message = "INT_PERCENTAGE/FLOAT_PERCENTAGE expected";
        System.err.println(message);
        return -3.4028235E38f;
    }

    public final String readName() throws IOException {
        char c;
        char[] chars = new char[256];
        int length = 0;
        while ((c = (char)this.din.readUnsignedByte()) != '\u0000') {
            if (chars.length <= length) {
                char[] tmp = new char[(int)((double)length * 1.5)];
                System.arraycopy(chars, 0, tmp, 0, length);
                chars = tmp;
            }
            chars[length++] = c;
        }
        return new String(chars, 0, length);
    }

    public final String readMatName(boolean readChunkID) throws IOException {
        if (readChunkID) {
            this.readUnsignedShort();
        }
        this.readInt();
        return this.readName();
    }

    public final float[] readColor(boolean readChunkID, int[] chunkID) throws IOException {
        int tag = readChunkID ? this.readUnsignedShort() : chunkID[0];
        if (tag == TDSChunkType.COLOR_F.getID()) {
            this.readInt();
            return new float[]{this.readFloat(), this.readFloat(), this.readFloat()};
        }
        if (tag == TDSChunkType.COLOR_24.getID()) {
            this.readInt();
            return new float[]{(float)this.din.readUnsignedByte() / 255.0f, (float)this.din.readUnsignedByte() / 255.0f, (float)this.din.readUnsignedByte() / 255.0f};
        }
        String message = "COLOR_F/COLOR_24 expected";
        System.err.println(message);
        return null;
    }

    private static final String createHexString(int chunkID) {
        String hex = Integer.toHexString(chunkID).toUpperCase();
        if (hex.length() >= 4) {
            return "0x" + hex;
        }
        char[] chars = new char[6];
        chars[0] = 48;
        chars[1] = 120;
        int n = 4 - hex.length();
        int i = 0;
        while (i < n) {
            chars[2 + i] = 48;
            ++i;
        }
        i = 0;
        while (i < hex.length()) {
            chars[2 + n + i] = hex.charAt(i);
            ++i;
        }
        return new String(chars);
    }

    public TDSChunkType processChunk() throws IOException {
        String logChunkType;
        int chunkID = this.readUnsignedShort();
        int length = this.readInt();
        ChunkProcessor cp = ChunkProcessor.getChunkProcessor(chunkID);
        TDSChunkType chunkType = TDSChunkType.valueOf(chunkID);
        String string = logChunkType = chunkType != null ? chunkType.name() : TDSFile.createHexString(chunkID);
        if (cp != null) {
            JAGTLog.debug("Processing chunk: ", logChunkType);
            cp.process(this, this.appFactory, this.geomFactory, this.nodeFactory, this.animFactory, this.siHandler, this.getContext(), length);
        } else {
            JAGTLog.debug("Skipping Chunk: ", logChunkType);
            this.skipChunk(length);
        }
        return chunkType;
    }

    public void close() throws IOException {
        this.din.close();
    }

    private TDSFile(InputStream in, URL baseURL, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        this.din = new DataInputStream(in);
        this.baseURL = baseURL;
        this.appFactory = appFactory;
        this.geomFactory = geomFactory;
        this.nodeFactory = nodeFactory;
        this.animFactory = animFactory;
        this.siHandler = siHandler;
        this.convertZup2Yup = convertZup2Yup;
    }

    private void finalizeModel(boolean convertZup2Yup, NamedObject rootGroup, NodeFactory nodeFactory, SpecialItemsHandler siHandler) {
        this.context.applyAppearanceAttributes(nodeFactory);
        for (NamedObject rootNode : this.context.rootNodes) {
            nodeFactory.addNodeToGroup(rootNode, rootGroup);
        }
        for (NamedObject shape : this.context.unanimatedNodes) {
            if (convertZup2Yup) {
                nodeFactory.rotateShapeOrGeometry(shape, Matrix3f.Z_UP_TO_Y_UP);
            }
            nodeFactory.addNodeToGroup(shape, rootGroup);
        }
        if (this.context.animationFound) {
            Object[] animControllers = (Object[])Array.newInstance(this.context.animControllers.get(0).getClass(), this.context.animControllers.size());
            this.context.animControllers.toArray(animControllers);
            Object animation = this.animFactory.createAnimation("default", this.context.framesCount, 25.0f, animControllers, null);
            siHandler.addAnimation(animation);
        }
    }

    public static final TDSFile load(InputStream in, URL baseURL, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        TDSFile file = new TDSFile(in, baseURL, appFactory, geomFactory, convertZup2Yup, nodeFactory, animFactory, siHandler);
        try {
            try {
                while (true) {
                    file.processChunk();
                }
            }
            catch (IOException e) {
                if (!(e instanceof EOFException)) {
                    throw e;
                }
                file.close();
            }
        }
        catch (Throwable throwable) {
            file.close();
            throw throwable;
        }
        file.finalizeModel(convertZup2Yup, rootGroup, nodeFactory, siHandler);
        return file;
    }
}

